/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.RestReindexAction;
import org.elasticsearch.index.reindex.TransportUpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.suggest.Suggesters;

public class RestUpdateByQueryAction
extends AbstractBaseReindexRestHandler<UpdateByQueryRequest, BulkIndexByScrollResponse, TransportUpdateByQueryAction> {
    @Inject
    public RestUpdateByQueryAction(Settings settings, RestController controller, Client client, ClusterService clusterService, IndicesQueriesRegistry indicesQueriesRegistry, AggregatorParsers aggParsers, Suggesters suggesters, TransportUpdateByQueryAction action) {
        super(settings, controller, client, clusterService, indicesQueriesRegistry, aggParsers, suggesters, action);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_update_by_query", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_update_by_query", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        UpdateByQueryRequest internalRequest = new UpdateByQueryRequest(new SearchRequest());
        internalRequest.setSize(request.paramAsInt("size", internalRequest.getSize()));
        request.params().remove("size");
        Tuple body = null;
        boolean bodyModified = false;
        if (RestActions.hasBodyContent((RestRequest)request)) {
            Integer size;
            Map script;
            body = XContentHelper.convertToMap((BytesReference)RestActions.getRestContent((RestRequest)request), (boolean)false);
            String conflicts = (String)((Map)body.v2()).remove("conflicts");
            if (conflicts != null) {
                internalRequest.setConflicts(conflicts);
                bodyModified = true;
            }
            if ((script = (Map)((Map)body.v2()).remove("script")) != null) {
                internalRequest.setScript(Script.parse((Map)script, (boolean)false, (ParseFieldMatcher)this.parseFieldMatcher));
                bodyModified = true;
            }
            if ((size = (Integer)((Map)body.v2()).remove("size")) != null) {
                internalRequest.setSize(size);
                bodyModified = true;
            }
        }
        if (request.hasParam("scroll_size")) {
            if (body == null) {
                body = new Tuple((Object)XContentType.JSON, new HashMap());
            }
            ((Map)body.v2()).put("size", request.paramAsInt("scroll_size", -1));
            bodyModified = true;
        }
        if (request.hasParam("search_timeout")) {
            ((Map)body.v2()).put("timeout", request.paramAsTime("search_timeout", null));
            bodyModified = true;
        }
        BytesReference bodyContent = null;
        if (bodyModified) {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)((XContentType)body.v1()));
            builder.map((Map)body.v2());
            bodyContent = builder.bytes();
        }
        RestSearchAction.parseSearchRequest((SearchRequest)internalRequest.getSearchRequest(), (RestRequest)request, (ParseFieldMatcher)this.parseFieldMatcher, bodyContent);
        String conflicts = request.param("conflicts");
        if (conflicts != null) {
            internalRequest.setConflicts(conflicts);
        }
        RestReindexAction.parseCommon(internalRequest, request);
        this.execute(request, internalRequest, channel);
    }
}

