/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.code.ExceptionHandler;
import org.jetbrains.java.decompiler.code.interpreter.Util;
import org.jetbrains.java.decompiler.struct.StructContext;

public class ExceptionTable {
    public static final ExceptionTable EMPTY = new ExceptionTable(null){

        @Override
        public List<ExceptionHandler> getHandlers() {
            return Collections.emptyList();
        }
    };
    private final List<ExceptionHandler> handlers;

    public ExceptionTable(List<ExceptionHandler> handlers) {
        this.handlers = handlers;
    }

    public ExceptionHandler getHandlerByClass(StructContext context, int line, String valclass, boolean withany) {
        ExceptionHandler res = null;
        for (ExceptionHandler handler : this.handlers) {
            if (handler.from > line || handler.to <= line) continue;
            String name = handler.exceptionClass;
            if ((!withany || name != null) && (name == null || !Util.instanceOf(context, valclass, name))) continue;
            res = handler;
            break;
        }
        return res;
    }

    public List<ExceptionHandler> getHandlers() {
        return this.handlers;
    }
}

