/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.client;

import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.utils.XmlUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstantRunBuildInfo {
    private static final boolean BUILDS_ARE_SORTED = false;
    private static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_API_LEVEL = "api-level";
    private static final String ATTR_FORMAT = "format";
    private static final String ATTR_VERIFIER_STATUS = "verifier";
    public static final String VALUE_VERIFIER_STATUS_COMPATIBLE = "COMPATIBLE";
    private static final String TAG_ARTIFACT = "artifact";
    private static final String TAG_BUILD = "build";
    private static final String ATTR_ARTIFACT_LOCATION = "location";
    private static final String ATTR_ARTIFACT_TYPE = "type";
    private final Element mRoot;
    private List<InstantRunArtifact> mArtifacts;

    public InstantRunBuildInfo(Element root) {
        this.mRoot = root;
    }

    public String getTimeStamp() {
        return this.mRoot.getAttribute(ATTR_TIMESTAMP);
    }

    public String getVerifierStatus() {
        return this.mRoot.getAttribute(ATTR_VERIFIER_STATUS);
    }

    public boolean canHotswap() {
        List<InstantRunArtifact> artifacts;
        String verifierStatus = this.getVerifierStatus();
        if (VALUE_VERIFIER_STATUS_COMPATIBLE.equals(verifierStatus)) {
            return true;
        }
        return verifierStatus.isEmpty() && (artifacts = this.getArtifacts()).size() == 1 && artifacts.get((int)0).type == InstantRunArtifactType.RESOURCES;
    }

    public boolean hasNoChanges() {
        return this.getArtifacts().isEmpty() && this.getVerifierStatus().isEmpty();
    }

    public int getFeatureLevel() {
        String attribute = this.mRoot.getAttribute(ATTR_API_LEVEL);
        if (attribute != null && !attribute.isEmpty()) {
            try {
                return Integer.parseInt(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public List<InstantRunArtifact> getArtifacts() {
        if (this.mArtifacts == null) {
            InstantRunArtifactType type;
            ArrayList artifacts = Lists.newArrayList();
            Node oldestBuild = null;
            long oldestTimeStamp = Long.MAX_VALUE;
            NodeList children = this.mRoot.getChildNodes();
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                Element element = (Element)child;
                String tagName = element.getTagName();
                if (!TAG_ARTIFACT.equals(tagName)) {
                    String timestamp;
                    if (!TAG_BUILD.equals(tagName) || (timestamp = element.getAttribute(ATTR_TIMESTAMP)).isEmpty()) continue;
                    try {
                        long time = Long.parseLong(timestamp);
                        if (time >= oldestTimeStamp) continue;
                        oldestTimeStamp = time;
                        oldestBuild = element;
                    }
                    catch (NumberFormatException time) {}
                    continue;
                }
                String location = element.getAttribute(ATTR_ARTIFACT_LOCATION);
                String typeAttribute = element.getAttribute(ATTR_ARTIFACT_TYPE);
                type = InstantRunArtifactType.valueOf(typeAttribute);
                artifacts.add(new InstantRunArtifact(type, new File(location)));
            }
            this.mArtifacts = artifacts;
            if (this.hasOneOf(InstantRunArtifactType.SPLIT_MAIN) && oldestBuild != null) {
                ListIterator iterator = artifacts.listIterator();
                while (iterator.hasNext()) {
                    InstantRunArtifact artifact = (InstantRunArtifact)iterator.next();
                    if (artifact.type != InstantRunArtifactType.SPLIT) continue;
                    iterator.remove();
                }
                NodeList nestedChildren = oldestBuild.getChildNodes();
                int n2 = nestedChildren.getLength();
                for (int j = 0; j < n2; ++j) {
                    String typeAttribute;
                    Element artifactElement;
                    Node nestedChild = nestedChildren.item(j);
                    if (nestedChild.getNodeType() != 1 || !TAG_ARTIFACT.equals((artifactElement = (Element)nestedChild).getTagName()) || (type = InstantRunArtifactType.valueOf(typeAttribute = artifactElement.getAttribute(ATTR_ARTIFACT_TYPE))) != InstantRunArtifactType.SPLIT) continue;
                    String location = artifactElement.getAttribute(ATTR_ARTIFACT_LOCATION);
                    artifacts.add(new InstantRunArtifact(type, new File(location)));
                }
            }
        }
        return this.mArtifacts;
    }

    public boolean hasOneOf(InstantRunArtifactType ... types) {
        for (InstantRunArtifact artifact : this.getArtifacts()) {
            for (InstantRunArtifactType type : types) {
                if (artifact.type != type) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMainApk() {
        return this.hasOneOf(InstantRunArtifactType.MAIN) || this.hasOneOf(InstantRunArtifactType.SPLIT_MAIN);
    }

    public static InstantRunBuildInfo get(String xml) {
        Document doc = XmlUtils.parseDocumentSilently((String)xml, (boolean)false);
        if (doc == null) {
            return null;
        }
        return new InstantRunBuildInfo(doc.getDocumentElement());
    }

    public boolean isCompatibleFormat() {
        return this.getFormat() == 7;
    }

    public int getFormat() {
        String attribute = this.mRoot.getAttribute(ATTR_FORMAT);
        if (Strings.isNullOrEmpty((String)attribute)) {
            return -1;
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }
}

