/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifySelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ModifyCacheHintJob
extends ModifySelectionJob {
    private int subJobCount = 0;
    private final PropertyName cachePN = new PropertyName("cache");
    private final PropertyName cacheHintPN = new PropertyName("cacheHint");

    public ModifyCacheHintJob(ValuePropertyMetadata propertyMetadata, Object newValue, EditorController editorController) {
        super(propertyMetadata, newValue, editorController);
        assert (this.cacheHintPN.equals(propertyMetadata.getName()));
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        HashSet<FXOMInstance> candidates = new HashSet<FXOMInstance>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fxomObject : osg.getItems()) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                candidates.add((FXOMInstance)fxomObject);
            }
        } else assert (selection.getGroup() == null) : "Add implementation for " + selection.getGroup();
        for (FXOMInstance fxomInstance : candidates) {
            ValuePropertyMetadata cacheVPM;
            ModifyObjectJob subJob2;
            ModifyObjectJob subJob1 = new ModifyObjectJob(fxomInstance, this.propertyMetadata, this.newValue, this.getEditorController());
            if (subJob1.isExecutable()) {
                result.add(subJob1);
                ++this.subJobCount;
            }
            if ("DEFAULT".equals(this.newValue) || !(subJob2 = new ModifyObjectJob(fxomInstance, cacheVPM = Metadata.getMetadata().queryValueProperty(fxomInstance, this.cachePN), Boolean.TRUE, this.getEditorController())).isExecutable()) continue;
            result.add(subJob2);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        switch (this.subJobCount) {
            case 0: {
                result = "Unexecutable Set";
                break;
            }
            case 1: {
                result = this.getSubJobs().get(0).getDescription();
                break;
            }
            default: {
                result = I18N.getString("label.action.edit.set.n", this.propertyMetadata.getName().toString(), this.subJobCount);
            }
        }
        return result;
    }
}

