/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.InsertRowConstraintsJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.MoveRowContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.RowConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.layout.GridPane;

public class InsertRowJob
extends BatchSelectionJob {
    private static final RowConstraintsListPropertyMetadata rowContraintsMeta = new RowConstraintsListPropertyMetadata(new PropertyName("rowConstraints"), true, Collections.emptyList(), InspectorPath.UNUSED);
    private final FXOMInstance gridPaneObject;
    private final int rowIndex;
    private final int insertCount;

    public InsertRowJob(FXOMObject gridPaneObject, int rowIndex, int insertCount, EditorController editorController) {
        super(editorController);
        assert (gridPaneObject instanceof FXOMInstance);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        assert (rowIndex >= 0);
        assert (rowIndex <= rowContraintsMeta.getValue((FXOMInstance)gridPaneObject).size());
        assert (insertCount >= 1);
        this.gridPaneObject = (FXOMInstance)gridPaneObject;
        this.rowIndex = rowIndex;
        this.insertCount = insertCount;
    }

    @Override
    protected List<Job> makeSubJobs() {
        int lastRowIndex;
        ArrayList<Job> result = new ArrayList<Job>();
        InsertRowConstraintsJob insertJob = new InsertRowConstraintsJob(this.gridPaneObject, this.rowIndex, this.insertCount, this.getEditorController());
        result.add(insertJob);
        for (int r = lastRowIndex = rowContraintsMeta.getValue(this.gridPaneObject).size() - 1; r >= this.rowIndex; --r) {
            MoveRowContentJob moveJob = new MoveRowContentJob(this.gridPaneObject, r, this.insertCount, this.getEditorController());
            if (!((Job)moveJob).isExecutable()) continue;
            result.add(moveJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        return new GridSelectionGroup((FXOMObject)this.gridPaneObject, GridSelectionGroup.Type.ROW, this.rowIndex);
    }
}

