/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;

public class GenericEditor
extends PropertyEditor {
    private TextField textField;

    public GenericEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.textField = new TextField();
        EventHandler onActionListener = event -> this.userUpdateValueProperty(this.getValue());
        this.setTextEditorBehavior(this, (Control)this.textField, (EventHandler<ActionEvent>)onActionListener);
        this.setDisable(true);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.textField);
    }

    @Override
    public Object getValue() {
        return this.textField.getText();
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.textField.setText(null);
        } else {
            this.textField.setText("" + value);
        }
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.textField.setPromptText(null);
        this.setDisable(true);
    }

    @Override
    protected void valueIsIndeterminate() {
        GenericEditor.handleIndeterminate((Node)this.textField);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.textField.requestFocus());
    }
}

