/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.xalan;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializationHandler;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class TracingSerializationHandler
implements SerializationHandler {
    private final LocalDebugger myDebugger;
    private final SerializationHandler mySerializationHandler;

    public TracingSerializationHandler(LocalDebugger debugger, SerializationHandler handler) {
        this.myDebugger = debugger;
        this.mySerializationHandler = handler;
    }

    private static String calcPrefix(String qname) {
        return qname.indexOf(58) == -1 ? "" : qname.split(":")[0];
    }

    public void setContentHandler(ContentHandler ch) {
        this.mySerializationHandler.setContentHandler(ch);
    }

    public void close() {
        this.mySerializationHandler.close();
    }

    public void serialize(Node node) throws IOException {
        this.mySerializationHandler.serialize(node);
    }

    public boolean setEscaping(boolean escape) throws SAXException {
        return this.mySerializationHandler.setEscaping(escape);
    }

    public void setIndentAmount(int spaces) {
        this.mySerializationHandler.setIndentAmount(spaces);
    }

    public void setTransformer(Transformer transformer) {
        this.mySerializationHandler.setTransformer(transformer);
    }

    public Transformer getTransformer() {
        return this.mySerializationHandler.getTransformer();
    }

    public void setNamespaceMappings(NamespaceMappings mappings) {
        this.mySerializationHandler.setNamespaceMappings(mappings);
    }

    public void flushPending() throws SAXException {
        this.mySerializationHandler.flushPending();
    }

    public void setDTDEntityExpansion(boolean expand) {
        this.mySerializationHandler.setDTDEntityExpansion(expand);
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value, boolean XSLAttribute) throws SAXException {
        this.myDebugger.getEventQueue().attribute(TracingSerializationHandler.calcPrefix(rawName), localName, uri, value);
        this.mySerializationHandler.addAttribute(uri, localName, rawName, type, value, XSLAttribute);
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws SAXException {
        this.myDebugger.getEventQueue().attribute("", localName, uri, value);
        this.mySerializationHandler.addAttribute(uri, localName, rawName, type, value);
    }

    public void addAttributes(Attributes atts) throws SAXException {
        this.mySerializationHandler.addAttributes(atts);
    }

    public void addAttribute(String qName, String value) {
        this.mySerializationHandler.addAttribute(qName, value);
    }

    public void characters(String chars) throws SAXException {
        this.mySerializationHandler.characters(chars);
    }

    public void characters(Node node) throws SAXException {
        this.mySerializationHandler.characters(node);
    }

    public void endElement(String elemName) throws SAXException {
        this.mySerializationHandler.endElement(elemName);
    }

    public void startElement(String uri, String localName, String qName) throws SAXException {
        this.myDebugger.getEventQueue().startElement(TracingSerializationHandler.calcPrefix(qName), localName, uri);
        this.mySerializationHandler.startElement(uri, localName, qName);
    }

    public void startElement(String qName) throws SAXException {
        this.mySerializationHandler.startElement(qName);
    }

    public void namespaceAfterStartElement(String uri, String prefix) throws SAXException {
        this.mySerializationHandler.namespaceAfterStartElement(uri, prefix);
    }

    public boolean startPrefixMapping(String prefix, String uri, boolean shouldFlush) throws SAXException {
        return this.mySerializationHandler.startPrefixMapping(prefix, uri, shouldFlush);
    }

    public void entityReference(String entityName) throws SAXException {
        this.mySerializationHandler.entityReference(entityName);
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.mySerializationHandler.getNamespaceMappings();
    }

    public String getPrefix(String uri) {
        return this.mySerializationHandler.getPrefix(uri);
    }

    public String getNamespaceURI(String name, boolean isElement) {
        return this.mySerializationHandler.getNamespaceURI(name, isElement);
    }

    public String getNamespaceURIFromPrefix(String prefix) {
        return this.mySerializationHandler.getNamespaceURIFromPrefix(prefix);
    }

    public void setSourceLocator(SourceLocator locator) {
        this.mySerializationHandler.setSourceLocator(locator);
    }

    public void addUniqueAttribute(String qName, String value, int flags) throws SAXException {
        this.mySerializationHandler.addUniqueAttribute(qName, value, flags);
    }

    public void addXSLAttribute(String qName, String value, String uri) {
        this.mySerializationHandler.addXSLAttribute(qName, value, uri);
    }

    public void setDocumentLocator(Locator locator) {
        this.mySerializationHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.mySerializationHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.mySerializationHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.mySerializationHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.mySerializationHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.mySerializationHandler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.mySerializationHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mySerializationHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.mySerializationHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.mySerializationHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.mySerializationHandler.skippedEntity(name);
    }

    public void comment(String comment) throws SAXException {
        this.mySerializationHandler.comment(comment);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.mySerializationHandler.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.mySerializationHandler.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.mySerializationHandler.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.mySerializationHandler.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.mySerializationHandler.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.mySerializationHandler.endCDATA();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.mySerializationHandler.comment(ch, start, length);
    }

    public String getDoctypePublic() {
        return this.mySerializationHandler.getDoctypePublic();
    }

    public String getDoctypeSystem() {
        return this.mySerializationHandler.getDoctypeSystem();
    }

    public String getEncoding() {
        return this.mySerializationHandler.getEncoding();
    }

    public boolean getIndent() {
        return this.mySerializationHandler.getIndent();
    }

    public int getIndentAmount() {
        return this.mySerializationHandler.getIndentAmount();
    }

    public String getMediaType() {
        return this.mySerializationHandler.getMediaType();
    }

    public boolean getOmitXMLDeclaration() {
        return this.mySerializationHandler.getOmitXMLDeclaration();
    }

    public String getStandalone() {
        return this.mySerializationHandler.getStandalone();
    }

    public String getVersion() {
        return this.mySerializationHandler.getVersion();
    }

    public void setCdataSectionElements(Vector URI_and_localNames) {
        this.mySerializationHandler.setCdataSectionElements(URI_and_localNames);
    }

    public void setDoctype(String system, String pub) {
        this.mySerializationHandler.setDoctype(system, pub);
    }

    public void setDoctypePublic(String doctype) {
        this.mySerializationHandler.setDoctypePublic(doctype);
    }

    public void setDoctypeSystem(String doctype) {
        this.mySerializationHandler.setDoctypeSystem(doctype);
    }

    public void setEncoding(String encoding) {
        this.mySerializationHandler.setEncoding(encoding);
    }

    public void setIndent(boolean indent) {
        this.mySerializationHandler.setIndent(indent);
    }

    public void setMediaType(String mediatype) {
        this.mySerializationHandler.setMediaType(mediatype);
    }

    public void setOmitXMLDeclaration(boolean b) {
        this.mySerializationHandler.setOmitXMLDeclaration(b);
    }

    public void setStandalone(String standalone) {
        this.mySerializationHandler.setStandalone(standalone);
    }

    public void setVersion(String version) {
        this.mySerializationHandler.setVersion(version);
    }

    public String getOutputProperty(String name) {
        return this.mySerializationHandler.getOutputProperty(name);
    }

    public String getOutputPropertyDefault(String name) {
        return this.mySerializationHandler.getOutputPropertyDefault(name);
    }

    public void setOutputProperty(String name, String val) {
        this.mySerializationHandler.setOutputProperty(name, val);
    }

    public void setOutputPropertyDefault(String name, String val) {
        this.mySerializationHandler.setOutputPropertyDefault(name, val);
    }

    public void elementDecl(String name, String model) throws SAXException {
        this.mySerializationHandler.elementDecl(name, model);
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        this.mySerializationHandler.attributeDecl(eName, aName, type, mode, value);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        this.mySerializationHandler.internalEntityDecl(name, value);
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.mySerializationHandler.externalEntityDecl(name, publicId, systemId);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.mySerializationHandler.notationDecl(name, publicId, systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.mySerializationHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.mySerializationHandler.warning(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.mySerializationHandler.error(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.mySerializationHandler.fatalError(exception);
    }

    public void setOutputStream(OutputStream output) {
        this.mySerializationHandler.setOutputStream(output);
    }

    public OutputStream getOutputStream() {
        return this.mySerializationHandler.getOutputStream();
    }

    public void setWriter(Writer writer) {
        this.mySerializationHandler.setWriter(writer);
    }

    public Writer getWriter() {
        return this.mySerializationHandler.getWriter();
    }

    public void setOutputFormat(Properties format) {
        this.mySerializationHandler.setOutputFormat(format);
    }

    public Properties getOutputFormat() {
        return this.mySerializationHandler.getOutputFormat();
    }

    public ContentHandler asContentHandler() throws IOException {
        return this.mySerializationHandler.asContentHandler();
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this.mySerializationHandler.asDOMSerializer();
    }

    public boolean reset() {
        return this.mySerializationHandler.reset();
    }

    public Object asDOM3Serializer() throws IOException {
        return this.mySerializationHandler.asDOM3Serializer();
    }
}

