/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.impl.gson.NullCheckingFactory;
import java.lang.reflect.Type;
import java.util.Date;

public class TaskGsonUtil {
    public static final JsonDeserializer<Date> DATE_DESERIALIZER = new JsonDeserializer<Date>(){

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TaskUtil.parseDate(json.getAsString());
        }
    };

    private TaskGsonUtil() {
    }

    public static GsonBuilder createDefaultBuilder() {
        return new GsonBuilder().registerTypeAdapter(Date.class, DATE_DESERIALIZER).registerTypeAdapterFactory((TypeAdapterFactory)NullCheckingFactory.INSTANCE);
    }
}

