/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GroovyTemplatesFactory
implements FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String[] TEMPLATES = new String[]{"GroovyClass.groovy", "GroovyScript.groovy"};
    private final ArrayList<String> myCustomTemplates = new ArrayList();
    @NonNls
    static final String NAME_TEMPLATE_PROPERTY = "NAME";
    static final String LOW_CASE_NAME_TEMPLATE_PROPERTY = "lowCaseName";

    public void registerCustromTemplates(String ... templates) {
        Collections.addAll(this.myCustomTemplates, templates);
    }

    public static GroovyTemplatesFactory getInstance() {
        return GroovyTemplatesFactoryHolder.myInstance;
    }

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor group = new FileTemplateGroupDescriptor(GroovyBundle.message("file.template.group.title.groovy", new Object[0]), JetgroovyIcons.Groovy.Groovy_16x16);
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (String template : TEMPLATES) {
            group.addTemplate(new FileTemplateDescriptor(template, fileTypeManager.getFileTypeByFileName(template).getIcon()));
        }
        group.addTemplate(new FileTemplateDescriptor("GroovyServerPage.gsp", fileTypeManager.getFileTypeByFileName("GroovyServerPage.gsp").getIcon()));
        for (String template : GroovyTemplatesFactory.getInstance().getCustomTemplates()) {
            group.addTemplate(new FileTemplateDescriptor(template, fileTypeManager.getFileTypeByFileName(template).getIcon()));
        }
        return group;
    }

    public static PsiFile createFromTemplate(@NotNull PsiDirectory directory, @NotNull String name, @NotNull String fileName, @NotNull String templateName, boolean allowReformatting, String ... parameters) throws IncorrectOperationException {
        String text;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/plugins/groovy/actions/GroovyTemplatesFactory", "createFromTemplate"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/actions/GroovyTemplatesFactory", "createFromTemplate"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/groovy/actions/GroovyTemplatesFactory", "createFromTemplate"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/plugins/groovy/actions/GroovyTemplatesFactory", "createFromTemplate"));
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)directory.getProject()).getInternalTemplate(templateName);
        Project project = directory.getProject();
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)project).getDefaultProperties());
        JavaTemplateUtil.setPackageNameAttribute((Properties)properties, (PsiDirectory)directory);
        properties.setProperty(NAME_TEMPLATE_PROPERTY, name);
        properties.setProperty(LOW_CASE_NAME_TEMPLATE_PROPERTY, name.substring(0, 1).toLowerCase() + name.substring(1));
        for (int i = 0; i < parameters.length; i += 2) {
            properties.setProperty(parameters[i], parameters[i + 1]);
        }
        try {
            text = template.getText(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load template for " + FileTemplateManager.getInstance((Project)project).internalTemplateToSubject(templateName), e);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        PsiFile file = factory.createFileFromText(fileName, (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)text);
        file = (PsiFile)directory.add((PsiElement)file);
        if (file != null && allowReformatting && template.isReformatCode()) {
            new ReformatCodeProcessor(project, file, null, false).run();
        }
        return file;
    }

    public String[] getCustomTemplates() {
        return ArrayUtil.toStringArray(this.myCustomTemplates);
    }

    private static class GroovyTemplatesFactoryHolder {
        private static final GroovyTemplatesFactory myInstance = new GroovyTemplatesFactory();

        private GroovyTemplatesFactoryHolder() {
        }
    }
}

