/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ExpressionStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class CommandArguments {
    public static boolean parseCommandArguments(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (CommandArguments.commandArgParse(builder, parser)) {
            while (ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                if (CommandArguments.commandArgParse(builder, parser)) continue;
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                break;
            }
            marker.done((IElementType)GroovyElementTypes.COMMAND_ARGUMENTS);
            return true;
        }
        marker.drop();
        return false;
    }

    private static boolean commandArgParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker commandMarker = builder.mark();
        Pair<Boolean, Boolean> check = ArgumentList.argumentLabelStartCheck(builder, parser);
        if (((Boolean)check.first).booleanValue()) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mCOLON, GroovyBundle.message("colon.expected", new Object[0]));
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (!ExpressionStatement.argParse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            commandMarker.done((IElementType)GroovyElementTypes.NAMED_ARGUMENT);
            return true;
        }
        commandMarker.drop();
        return (Boolean)check.second != false || ExpressionStatement.argParse(builder, parser);
    }
}

