/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DevicePropertyUtil {
    private static final Set<String> ourManufacturerNameIsAcronym = ImmutableSet.of((Object)"ASUS", (Object)"HTC", (Object)"LG", (Object)"LGE", (Object)"ZTE");

    static String fixManufacturerName(@NotNull String manufacturer) {
        if (manufacturer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manufacturer", "com/android/tools/idea/ddms/DevicePropertyUtil", "fixManufacturerName"));
        }
        String allCaps = manufacturer.toUpperCase(Locale.US);
        return ourManufacturerNameIsAcronym.contains(allCaps) ? allCaps : StringUtil.capitalizeWords((String)manufacturer, (boolean)true);
    }

    @NotNull
    public static String getManufacturer(@NotNull IDevice d, @NotNull String unknown) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/ddms/DevicePropertyUtil", "getManufacturer"));
        }
        if (unknown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknown", "com/android/tools/idea/ddms/DevicePropertyUtil", "getManufacturer"));
        }
        String m = d.getProperty("ro.product.manufacturer");
        if (d.isEmulator() && "unknown".equals(m)) {
            m = unknown;
        }
        String string = m != null ? DevicePropertyUtil.fixManufacturerName(m) : unknown;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePropertyUtil", "getManufacturer"));
        }
        return string;
    }

    @NotNull
    public static String getModel(@NotNull IDevice d, @NotNull String unknown) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/ddms/DevicePropertyUtil", "getModel"));
        }
        if (unknown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknown", "com/android/tools/idea/ddms/DevicePropertyUtil", "getModel"));
        }
        String m = d.getProperty("ro.product.model");
        String string = m != null ? StringUtil.capitalizeWords((String)m, (boolean)true) : unknown;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePropertyUtil", "getModel"));
        }
        return string;
    }

    @NotNull
    public static String getBuild(@NotNull IDevice d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/ddms/DevicePropertyUtil", "getBuild"));
        }
        StringBuilder sb = new StringBuilder(20);
        String v = d.getProperty("ro.build.version.release");
        if (v != null) {
            sb.append("Android ");
            sb.append(v);
        }
        if ((v = d.getProperty("ro.build.version.sdk")) != null) {
            sb.append(String.format(", API %1$s", v));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePropertyUtil", "getBuild"));
        }
        return string;
    }
}

