/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.SourceProvider;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ide.common.packaging.PackagingUtils;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.AppState;
import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.fd.client.UserFeedback;
import com.android.tools.fd.runtime.ApplicationPatch;
import com.android.tools.idea.fd.FileChangeListener;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunUserFeedback;
import com.android.tools.idea.fd.LogWrapper;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidProgramRunner;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.stats.UsageTracker;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.io.Files;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.xdebugger.XDebugSession;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstantRunManager
implements ProjectComponent {
    public static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.0.0";
    public static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.0.0");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"InstantRun", (String)ToolWindowId.RUN);
    public static final Logger LOG = Logger.getInstance((String)"#InstantRun");
    private static final ILogger ILOGGER = new LogWrapper(LOG);
    public static final ImmutableSet<String> ALLOWED_PROCESSES = ImmutableSet.of((Object)":leakcanary");
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileChangeListener myFileChangeListener;

    public InstantRunManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunManager", "<init>"));
        }
        this.myProject = project;
        this.myFileChangeListener = new FileChangeListener(project);
        this.myFileChangeListener.setEnabled(InstantRunSettings.isInstantRunEnabled());
    }

    @NotNull
    public static InstantRunManager get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunManager", "get"));
        }
        InstantRunManager instantRunManager = (InstantRunManager)project.getComponent(InstantRunManager.class);
        if (instantRunManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "get"));
        }
        return instantRunManager;
    }

    @NotNull
    public static List<IDevice> findDevices(@Nullable Project project) {
        if (project == null) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "findDevices"));
            }
            return list;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "findDevices"));
            }
            return list;
        }
        ArrayList devices = Lists.newArrayList();
        for (RunContentDescriptor descriptor : runningProcesses) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) continue;
            devices.addAll(InstantRunManager.getConnectedDevices(processHandler));
        }
        ArrayList arrayList = devices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "findDevices"));
        }
        return arrayList;
    }

    @NotNull
    private static List<IDevice> getConnectedDevices(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/android/tools/idea/fd/InstantRunManager", "getConnectedDevices"));
        }
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getConnectedDevices"));
            }
            return list;
        }
        if (processHandler instanceof AndroidProcessHandler) {
            ImmutableList immutableList = ImmutableList.copyOf(((AndroidProcessHandler)processHandler).getDevices());
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getConnectedDevices"));
            }
            return immutableList;
        }
        Client c = (Client)processHandler.getUserData(AndroidProgramRunner.ANDROID_DEBUG_CLIENT);
        if (c != null && c.isValid()) {
            List<IDevice> list = Collections.singletonList(c.getDevice());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getConnectedDevices"));
            }
            return list;
        }
        List<IDevice> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getConnectedDevices"));
        }
        return list;
    }

    @NotNull
    public static AndroidVersion getMinDeviceApiLevel(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/android/tools/idea/fd/InstantRunManager", "getMinDeviceApiLevel"));
        }
        AndroidVersion version = (AndroidVersion)processHandler.getUserData(AndroidProgramRunner.ANDROID_DEVICE_API_LEVEL);
        AndroidVersion androidVersion = version == null ? AndroidVersion.DEFAULT : version;
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getMinDeviceApiLevel"));
        }
        return androidVersion;
    }

    public static boolean isAppInForeground(@NotNull IDevice device, @NotNull Module module) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "isAppInForeground"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "isAppInForeground"));
        }
        return InstantRunManager.getInstantRunClient(module).getAppState(device) == AppState.FOREGROUND;
    }

    @Nullable
    private static String getLocalBuildTimestamp(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "getLocalBuildTimestamp"));
        }
        AndroidGradleModel model = InstantRunGradleUtils.getAppModel(module);
        InstantRunBuildInfo buildInfo = model == null ? null : InstantRunGradleUtils.getBuildInfo(model);
        return buildInfo == null ? null : buildInfo.getTimeStamp();
    }

    public static boolean buildTimestampsMatch(@NotNull IDevice device, @NotNull Module module) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "buildTimestampsMatch"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "buildTimestampsMatch"));
        }
        String localTimestamp = InstantRunManager.getLocalBuildTimestamp(module);
        if (StringUtil.isEmpty((String)localTimestamp)) {
            LOG.info("Local build timestamp is empty!");
            return false;
        }
        if (InstantRunClient.USE_BUILD_ID_TEMP_FILE) {
            String pkgName;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : "Instant Run requires a Gradle model";
            try {
                pkgName = ApkProviderUtil.computePackageName(facet);
            }
            catch (ApkProvisionException e) {
                throw new RuntimeException(e);
            }
            if (((InstalledApkCache)ServiceManager.getService(InstalledApkCache.class)).getLastUpdateTime(device, pkgName) == null) {
                LOG.info("Package " + pkgName + " was not detected on the device.");
                return false;
            }
        }
        String deviceBuildTimestamp = InstantRunManager.getInstantRunClient(module).getDeviceBuildTimestamp(device);
        LOG.info(String.format("Build timestamps: Local: %1$s, Device: %2$s", localTimestamp, deviceBuildTimestamp));
        return localTimestamp.equals(deviceBuildTimestamp);
    }

    public static boolean apiLevelsMatch(@NotNull IDevice device, @NotNull Module module) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "apiLevelsMatch"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "apiLevelsMatch"));
        }
        AndroidGradleModel model = InstantRunGradleUtils.getAppModel(module);
        InstantRunBuildInfo buildInfo = model == null ? null : InstantRunGradleUtils.getBuildInfo(model);
        return buildInfo != null && buildInfo.getFeatureLevel() == device.getVersion().getFeatureLevel();
    }

    public static void transferLocalIdToDeviceId(@NotNull IDevice device, @NotNull Module module) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "transferLocalIdToDeviceId"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "transferLocalIdToDeviceId"));
        }
        String buildId = InstantRunManager.getLocalBuildTimestamp(module);
        assert (!StringUtil.isEmpty((String)buildId)) : "Unable to detect build timestamp";
        InstantRunManager.getInstantRunClient(module).transferLocalIdToDeviceId(device, buildId);
    }

    public static void restartActivity(@NotNull IDevice device, @NotNull Module module) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "restartActivity"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "restartActivity"));
        }
        InstantRunManager.getInstantRunClient(module).restartActivity(device);
    }

    public static boolean isInstantRunCapableDeviceVersion(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/fd/InstantRunManager", "isInstantRunCapableDeviceVersion"));
        }
        return version.getApiLevel() >= 15;
    }

    public static boolean manifestChanged(@NotNull IDevice device, @NotNull AndroidFacet facet, @NotNull String pkgName) {
        long installedTimeStamp;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "manifestChanged"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "manifestChanged"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/fd/InstantRunManager", "manifestChanged"));
        }
        InstalledPatchCache cache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        long currentTimeStamp = InstantRunManager.getManifestLastModified(facet);
        return currentTimeStamp > (installedTimeStamp = cache.getInstalledManifestTimestamp(device, pkgName));
    }

    public static boolean manifestResourceChanged(@NotNull IDevice device, @NotNull AndroidFacet facet, @NotNull String pkgName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "manifestResourceChanged"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "manifestResourceChanged"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/fd/InstantRunManager", "manifestResourceChanged"));
        }
        InstalledPatchCache cache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        HashCode currentHash = InstalledPatchCache.computeManifestResources(facet);
        HashCode installedHash = cache.getInstalledManifestResourcesHash(device, pkgName);
        return installedHash != null && !installedHash.equals((Object)currentHash);
    }

    public static boolean hasLocalCacheOfDeviceData(@NotNull IDevice device, @NotNull Module module) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "hasLocalCacheOfDeviceData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "hasLocalCacheOfDeviceData"));
        }
        AndroidFacet facet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        if (facet == null) {
            return false;
        }
        String pkgName = InstantRunManager.getPackageName(facet);
        if (pkgName == null) {
            return true;
        }
        InstalledPatchCache cache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        return cache.getInstalledManifestTimestamp(device, pkgName) > 0L;
    }

    public static long getManifestLastModified(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "getManifestLastModified"));
        }
        long maxLastModified = 0L;
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            for (SourceProvider provider : androidModel.getActiveSourceProviders()) {
                File manifest = provider.getManifestFile();
                long lastModified = manifest.lastModified();
                maxLastModified = Math.max(maxLastModified, lastModified);
            }
        }
        return maxLastModified;
    }

    public static boolean usesMultipleProcesses(@NotNull Module module) {
        String xml;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "usesMultipleProcesses"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return false;
        }
        File manifest = InstantRunManager.findMergedManifestFile(facet);
        if (manifest == null || !manifest.exists()) {
            return false;
        }
        try {
            xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.warn("Error while reading merged manifest", (Throwable)e);
            return false;
        }
        return InstantRunManager.manifestSpecifiesMultiProcess(xml, ALLOWED_PROCESSES);
    }

    static boolean manifestSpecifiesMultiProcess(@NotNull String manifest, @NotNull Set<String> allowedProcesses) {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "com/android/tools/idea/fd/InstantRunManager", "manifestSpecifiesMultiProcess"));
        }
        if (allowedProcesses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedProcesses", "com/android/tools/idea/fd/InstantRunManager", "manifestSpecifiesMultiProcess"));
        }
        Matcher m = Pattern.compile("android:process\\s?=\\s?\"(.*)\"").matcher(manifest);
        while (m.find()) {
            String group = m.group(1);
            if (allowedProcesses.contains(group)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getComponentName() {
        if ("InstantRunManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getComponentName"));
        }
        return "InstantRunManager";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public FileChangeListener.Changes getChangesAndReset() {
        return this.myFileChangeListener.getChangesAndReset();
    }

    static void updateFileListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunManager", "updateFileListener"));
        }
        InstantRunManager manager = InstantRunManager.get(project);
        manager.myFileChangeListener.setEnabled(InstantRunSettings.isInstantRunEnabled());
    }

    @Nullable
    public static File findMergedManifestFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "findMergedManifestFile"));
        }
        AndroidGradleModel model = AndroidGradleModel.get(facet);
        if (model != null) {
            AndroidArtifact mainArtifact = model.getSelectedVariant().getMainArtifact();
            Collection outputs = mainArtifact.getOutputs();
            for (AndroidArtifactOutput output : outputs) {
                File manifest = output.getGeneratedManifest();
                if (!manifest.exists()) continue;
                return manifest;
            }
        }
        return null;
    }

    @NotNull
    private static InstantRunClient getInstantRunClient(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "getInstantRunClient"));
        }
        AndroidFacet facet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        assert (facet != null) : module;
        AndroidGradleModel model = AndroidGradleModel.get(facet);
        assert (model != null);
        InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(model, facet);
        if (instantRunClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getInstantRunClient"));
        }
        return instantRunClient;
    }

    @NotNull
    private static InstantRunClient getInstantRunClient(@NotNull AndroidGradleModel model, @NotNull AndroidFacet facet) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/InstantRunManager", "getInstantRunClient"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "getInstantRunClient"));
        }
        String packageName = InstantRunManager.getPackageName(facet);
        assert (packageName != null) : "Unable to obtain package name for " + facet.getModule().getName();
        long token = PackagingUtils.computeApplicationHash((File)model.getAndroidProject().getBuildFolder());
        InstantRunClient instantRunClient = new InstantRunClient(packageName, (UserFeedback)new InstantRunUserFeedback(facet.getModule()), ILOGGER, token);
        if (instantRunClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getInstantRunClient"));
        }
        return instantRunClient;
    }

    public boolean pushArtifacts(@NotNull IDevice device, @NotNull AndroidFacet facet, @NotNull UpdateMode updateMode, @NotNull InstantRunBuildInfo buildInfo) throws InstantRunPushFailedException {
        boolean needRestart;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        if (updateMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMode", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        if (buildInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildInfo", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        if (!buildInfo.canHotswap()) {
            updateMode = updateMode.combine(UpdateMode.COLD_SWAP);
        }
        AndroidGradleModel model = AndroidGradleModel.get(facet);
        assert (model != null) : "Instant Run push artifacts called without a Gradle model";
        ArrayList files = Lists.newArrayList();
        InstantRunClient client = InstantRunManager.getInstantRunClient(model, facet);
        AppState appState = InstantRunManager.getInstantRunClient(facet.getModule()).getAppState(device);
        boolean appInForeground = appState == AppState.FOREGROUND;
        boolean appRunning = appState == AppState.FOREGROUND || appState == AppState.BACKGROUND;
        List artifacts = buildInfo.getArtifacts();
        block7: for (InstantRunArtifact artifact : artifacts) {
            InstantRunArtifactType type = artifact.type;
            File file = artifact.file;
            switch (type) {
                case MAIN: 
                case SPLIT_MAIN: {
                    continue block7;
                }
                case SPLIT: {
                    assert (false) : artifact;
                    continue block7;
                }
                case RESOURCES: {
                    updateMode = updateMode.combine(UpdateMode.WARM_SWAP);
                    files.add(InstantRunClient.FileTransfer.createResourceFile((File)file));
                    continue block7;
                }
                case DEX: {
                    String name = file.getParentFile().getName() + "-" + file.getName();
                    files.add(InstantRunClient.FileTransfer.createSliceDex((File)file, (String)name));
                    continue block7;
                }
                case RELOAD_DEX: {
                    if (appInForeground) {
                        files.add(InstantRunClient.FileTransfer.createHotswapPatch((File)file));
                        continue block7;
                    }
                    if (buildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.DEX, InstantRunArtifactType.SPLIT})) continue block7;
                    throw new InstantRunPushFailedException("Can't apply hot swap patch: app is no longer running");
                }
            }
            assert (false) : artifact;
        }
        String pkgName = InstantRunManager.getPackageName(facet);
        String buildId = InstantRunManager.getLocalBuildTimestamp(facet.getModule());
        assert (!StringUtil.isEmpty((String)buildId)) : "Unable to detect build timestamp";
        if (appRunning) {
            List<ApplicationPatch> changes = InstantRunManager.getApplicationPatches(files);
            boolean restartActivity = InstantRunSettings.isRestartActivity();
            boolean showToast = InstantRunSettings.isShowToastEnabled();
            client.pushPatches(device, buildId, changes, updateMode, restartActivity, showToast);
            if (pkgName != null) {
                this.refreshDebugger(pkgName);
            }
            needRestart = false;
            if (!appInForeground || !buildInfo.canHotswap()) {
                client.stopApp(device, false);
                needRestart = true;
            }
        } else {
            client.pushFiles((List)files, device, buildId);
            needRestart = true;
        }
        InstantRunManager.logFilesPushed(files, needRestart);
        return needRestart;
    }

    private static void logFilesPushed(@NotNull List<InstantRunClient.FileTransfer> files, boolean needRestart) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/fd/InstantRunManager", "logFilesPushed"));
        }
        StringBuilder sb = new StringBuilder("Pushing files: ");
        if (needRestart) {
            sb.append("(needs restart) ");
        }
        sb.append('[');
        String separator = "";
        for (int i = 0; i < files.size(); ++i) {
            sb.append(separator);
            sb.append(files.get((int)i).source.getName());
            sb.append(" as ");
            sb.append(files.get((int)i).name);
            separator = ", ";
        }
        sb.append(']');
        LOG.info(sb.toString());
    }

    private static List<ApplicationPatch> getApplicationPatches(List<InstantRunClient.FileTransfer> files) {
        ArrayList<ApplicationPatch> changes = new ArrayList<ApplicationPatch>(files.size());
        for (InstantRunClient.FileTransfer file : files) {
            try {
                changes.add(file.getPatch());
            }
            catch (IOException e) {
                LOG.warn("Couldn't read file " + file);
            }
        }
        return changes;
    }

    private void refreshDebugger(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/fd/InstantRunManager", "refreshDebugger"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)InstantRunManager.this.myProject);
                if (!debugger.getSessions().isEmpty()) {
                    List breakpoints = debugger.getBreakpointManager().getBreakpoints();
                    for (Breakpoint breakpoint : breakpoints) {
                        if (!breakpoint.isEnabled()) continue;
                        breakpoint.setEnabled(false);
                        breakpoint.setEnabled(true);
                    }
                }
            }
        });
        DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)this.myProject);
        for (final DebuggerSession session : debugger.getSessions()) {
            Client client = (Client)session.getProcess().getProcessHandler().getUserData(AndroidProgramRunner.ANDROID_DEBUG_CLIENT);
            if (client == null || !client.isValid() || !StringUtil.equals((CharSequence)packageName, (CharSequence)client.getClientData().getClientDescription())) continue;
            session.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

                protected void action() throws Exception {
                    JavaExecutionStack stack;
                    DebuggerContextImpl context = session.getContextManager().getContext();
                    SuspendContextImpl suspendContext = context.getSuspendContext();
                    if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
                        stack.initTopFrame();
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            session.refresh(false);
                            XDebugSession xSession = session.getXDebugSession();
                            if (xSession != null) {
                                xSession.resume();
                            }
                        }
                    });
                }
            });
        }
    }

    public static void displayVerifierStatus(@NotNull AndroidFacet facet, @NotNull InstantRunBuildInfo buildInfo) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/InstantRunManager", "displayVerifierStatus"));
        }
        if (buildInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildInfo", "com/android/tools/idea/fd/InstantRunManager", "displayVerifierStatus"));
        }
        String message = InstantRunManager.getVerifierMessage(buildInfo);
        if (message != null) {
            new InstantRunUserFeedback(facet.getModule()).verifierFailure(message);
            String status = buildInfo.getVerifierStatus();
            LOG.info("Instant run verifier failure: " + status);
            UsageTracker.getInstance().trackEvent("instantrun", "buildCause", status, null);
        } else {
            UsageTracker.getInstance().trackEvent("instantrun", "buildCause", "COMPATIBLE", null);
        }
    }

    @Language(value="HTML")
    @Nullable
    public static String getVerifierMessage(@NotNull InstantRunBuildInfo buildInfo) {
        if (buildInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildInfo", "com/android/tools/idea/fd/InstantRunManager", "getVerifierMessage"));
        }
        if (!buildInfo.canHotswap()) {
            String status = buildInfo.getVerifierStatus();
            if (status.isEmpty()) {
                return null;
            }
            status = StringUtil.capitalizeWords((String)status.toLowerCase(Locale.US).replace('_', ' '), (boolean)true);
            return "Instant Run restarted app to apply changes: " + status;
        }
        return null;
    }

    @Nullable
    private static String getPackageName(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return null;
        }
        try {
            return ApkProviderUtil.computePackageName(facet);
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public static void showToast(@NotNull IDevice device, @NotNull Module module, @NotNull String message) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "showToast"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunManager", "showToast"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/fd/InstantRunManager", "showToast"));
        }
        try {
            InstantRunManager.getInstantRunClient(module).showToast(device, message);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }
}

