/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.model;

import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.configurables.model.Coordinates;
import com.android.tools.idea.gradle.structure.configurables.model.DependencyMergedModel;
import com.android.tools.idea.gradle.structure.configurables.model.ModuleMergedModel;
import com.google.common.collect.Lists;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDependencyMergedModel
extends DependencyMergedModel {
    @NotNull
    private final List<ModuleMergedModel.LogicalArtifactDependency> myLogicalModels;
    @NotNull
    private final ArtifactDependencyModel myParsedModel;
    @NotNull
    private final GradleCoordinate myCoordinate;

    @Nullable
    static ArtifactDependencyMergedModel create(@NotNull ModuleMergedModel parent, @NotNull ArtifactDependencyModel parsedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "create"));
        }
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "create"));
        }
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)parsedModel.getSpec().compactNotation());
        if (coordinate != null) {
            return new ArtifactDependencyMergedModel(parent, Collections.emptyList(), coordinate, parsedModel);
        }
        return null;
    }

    @Nullable
    static ArtifactDependencyMergedModel create(@NotNull ModuleMergedModel parent, @NotNull Collection<ModuleMergedModel.LogicalArtifactDependency> logicalModels, @NotNull ArtifactDependencyModel parsedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "create"));
        }
        if (logicalModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalModels", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "create"));
        }
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "create"));
        }
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)parsedModel.getSpec().compactNotation());
        if (coordinate != null) {
            return new ArtifactDependencyMergedModel(parent, logicalModels, coordinate, parsedModel);
        }
        return null;
    }

    private ArtifactDependencyMergedModel(@NotNull ModuleMergedModel parent, @NotNull Collection<ModuleMergedModel.LogicalArtifactDependency> logicalModels, @NotNull GradleCoordinate coordinate, @NotNull ArtifactDependencyModel parsedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "<init>"));
        }
        if (logicalModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalModels", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "<init>"));
        }
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "<init>"));
        }
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "<init>"));
        }
        super(parent, parsedModel.configurationName());
        this.myLogicalModels = Lists.newArrayList(logicalModels);
        this.myCoordinate = coordinate;
        this.myParsedModel = parsedModel;
    }

    @Override
    public boolean isInAndroidProject() {
        return !this.myLogicalModels.isEmpty();
    }

    public boolean matches(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "matches"));
        }
        for (ModuleMergedModel.LogicalArtifactDependency model : this.myLogicalModels) {
            if (model.dependency == library) {
                return true;
            }
            MavenCoordinates resolved = library.getResolvedCoordinates();
            if (resolved == null || !Coordinates.areEqual(this.myCoordinate, Coordinates.convert(resolved))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PlatformIcons.LIBRARY_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public GradleCoordinate getCoordinate() {
        GradleCoordinate gradleCoordinate = this.myCoordinate;
        if (gradleCoordinate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ArtifactDependencyMergedModel", "getCoordinate"));
        }
        return gradleCoordinate;
    }

    public String toString() {
        return this.myParsedModel.getSpec().compactNotation();
    }
}

