/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdkv2;

import com.android.SdkConstants;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.installer.BasicInstaller;
import com.android.repository.io.FileOp;
import com.android.tools.idea.ddms.adb.AdbService;
import java.io.File;
import java.util.Map;

public class PlatformToolsInstaller
extends BasicInstaller {
    public boolean uninstall(LocalPackage p, ProgressIndicator progress, RepoManager manager, FileOp fop) {
        PlatformToolsInstaller.stopAdb(progress, manager);
        return super.uninstall(p, progress, manager, fop);
    }

    public boolean install(RemotePackage p, Downloader downloader, SettingsController settings, ProgressIndicator progress, RepoManager manager, FileOp fop) {
        PlatformToolsInstaller.stopAdb(progress, manager);
        return super.install(p, downloader, settings, progress, manager, fop);
    }

    private static void stopAdb(ProgressIndicator progress, RepoManager manager) {
        AdbService adbService = AdbService.getInstance();
        progress.logInfo("Stopping ADB...");
        File adb = PlatformToolsInstaller.getAdb(manager);
        if (adb != null) {
            try {
                adbService.getDebugBridge(adb).get();
            }
            catch (Exception e) {
                progress.logWarning("Failed to get ADB instance", (Throwable)e);
            }
        }
        adbService.terminateDdmlib();
    }

    private static File getAdb(RepoManager manager) {
        Map localPackages = manager.getPackages().getLocalPackages();
        LocalPackage localPackage = (LocalPackage)localPackages.get("platform-tools");
        if (localPackage != null) {
            return new File(localPackage.getLocation().getPath(), SdkConstants.FN_ADB);
        }
        return null;
    }
}

