/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.adapters;

import com.android.tools.idea.ui.properties.ObservableProperty;
import com.android.tools.idea.ui.properties.adapters.AdapterProperty;
import org.jetbrains.annotations.NotNull;

public final class StringToDoubleAdapterProperty
extends AdapterProperty<String, Double> {
    @NotNull
    private final String myFormatString;

    public StringToDoubleAdapterProperty(@NotNull ObservableProperty<String> wrappedProperty) {
        if (wrappedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedProperty", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "<init>"));
        }
        this(wrappedProperty, 1);
    }

    public StringToDoubleAdapterProperty(@NotNull ObservableProperty<String> wrappedProperty, int numDecimals) {
        if (wrappedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedProperty", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "<init>"));
        }
        super(wrappedProperty);
        this.myFormatString = "%1$." + numDecimals + "f";
    }

    @Override
    @NotNull
    protected Double convertFromSourceType(@NotNull String value) {
        Double d;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromSourceType"));
        }
        try {
            d = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            Double d2 = 0.0;
            if (d2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromSourceType"));
            }
            return d2;
        }
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromSourceType"));
        }
        return d;
    }

    @Override
    @NotNull
    protected String convertFromDestType(@NotNull Double value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromDestType"));
        }
        String string = String.format(this.myFormatString, value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/adapters/StringToDoubleAdapterProperty", "convertFromDestType"));
        }
        return string;
    }
}

