/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public class TagListDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JList myList = new JBList(new DefaultListModel());
    private ArrayList<String> myData;

    public TagListDialog(String title) {
        super(true);
        this.myPanel = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String tagName = Messages.showInputDialog((String)ApplicationBundle.message((String)"editbox.enter.tag.name", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"title.tag.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (tagName != null) {
                    while (TagListDialog.this.myData.contains(tagName)) {
                        TagListDialog.this.myData.remove(tagName);
                    }
                    TagListDialog.this.myData.add(tagName);
                    TagListDialog.this.updateData();
                    TagListDialog.this.myList.setSelectedIndex(TagListDialog.this.myData.size() - 1);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedIndex = TagListDialog.this.myList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    TagListDialog.this.myData.remove(selectedIndex);
                    TagListDialog.this.updateData();
                    if (selectedIndex >= TagListDialog.this.myData.size()) {
                        --selectedIndex;
                    }
                    if (selectedIndex >= 0) {
                        TagListDialog.this.myList.setSelectedIndex(selectedIndex);
                    }
                }
            }
        }).disableUpDownActions().createPanel();
        this.setTitle(title);
        this.init();
    }

    public void setData(ArrayList<String> data) {
        this.myData = data;
        this.updateData();
        if (!this.myData.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
    }

    private void updateData() {
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        model.clear();
        for (String data : this.myData) {
            model.addElement(data);
        }
    }

    public ArrayList<String> getData() {
        return this.myData;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }
}

