/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBCheckboxMenuItem;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class DaemonEditorPopup
extends PopupHandler {
    private final PsiFile myPsiFile;

    public DaemonEditorPopup(PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }

    public void invokePopup(final Component comp, final int x, final int y) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        final JRadioButtonMenuItem errorsFirst = DaemonEditorPopup.createRadioButtonMenuItem(EditorBundle.message((String)"errors.panel.go.to.errors.first.radio", (Object[])new Object[0]));
        errorsFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonCodeAnalyzerSettings.getInstance().NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST = errorsFirst.isSelected();
            }
        });
        JBPopupMenu popupMenu = new JBPopupMenu();
        popupMenu.add(errorsFirst);
        final JRadioButtonMenuItem next = DaemonEditorPopup.createRadioButtonMenuItem(EditorBundle.message((String)"errors.panel.go.to.next.error.warning.radio", (Object[])new Object[0]));
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonCodeAnalyzerSettings.getInstance().NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST = !next.isSelected();
            }
        });
        popupMenu.add(next);
        ButtonGroup group = new ButtonGroup();
        group.add(errorsFirst);
        group.add(next);
        popupMenu.addSeparator();
        JBMenuItem hLevel = new JBMenuItem(EditorBundle.message((String)"customize.highlighting.level.menu.item", (Object[])new Object[0]));
        popupMenu.add((JMenuItem)hLevel);
        boolean isErrorsFirst = DaemonCodeAnalyzerSettings.getInstance().NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST;
        errorsFirst.setSelected(isErrorsFirst);
        next.setSelected(!isErrorsFirst);
        hLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiFile psiFile = DaemonEditorPopup.this.myPsiFile;
                if (psiFile == null) {
                    return;
                }
                HectorComponent component = new HectorComponent(psiFile);
                Dimension dimension = component.getPreferredSize();
                Point point = new Point(x, y);
                component.showComponent(new RelativePoint(comp, new Point(point.x - dimension.width, point.y)));
            }
        });
        final JBCheckboxMenuItem previewCheckbox = new JBCheckboxMenuItem(IdeBundle.message((String)"checkbox.show.editor.preview.popup", (Object[])new Object[0]), UISettings.getInstance().SHOW_EDITOR_TOOLTIP);
        popupMenu.addSeparator();
        popupMenu.add((JMenuItem)previewCheckbox);
        previewCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UISettings.getInstance().SHOW_EDITOR_TOOLTIP = previewCheckbox.isSelected();
                UISettings.getInstance().fireUISettingsChanged();
            }
        });
        PsiFile file2 = this.myPsiFile;
        if (file2 != null && DaemonCodeAnalyzer.getInstance((Project)this.myPsiFile.getProject()).isHighlightingAvailable(file2)) {
            popupMenu.show(comp, x, y);
        }
    }

    private static JRadioButtonMenuItem createRadioButtonMenuItem(String message) {
        return new JRadioButtonMenuItem(message){

            @Override
            public void paint(Graphics g) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                super.paint(g);
            }
        };
    }
}

