/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class InspectionNodeInfo
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InspectionNodeInfo.class);

    public InspectionNodeInfo(@NotNull InspectionTree tree, final @NotNull Project project2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/ui/InspectionNodeInfo", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/InspectionNodeInfo", "<init>"));
        }
        this.setLayout(new GridBagLayout());
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)11, (int)0, (int)0, (int)0));
        InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(true);
        LOG.assertTrue(toolWrapper != null);
        InspectionProfileImpl currentProfile = (InspectionProfileImpl)InspectionProjectProfileManager.getInstance(project2).getProjectProfileImpl();
        final HighlightDisplayKey key2 = HighlightDisplayKey.find((String)toolWrapper.getShortName());
        final boolean enabled = currentProfile.isToolEnabled(key2);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 2));
        JBLabelDecorator label = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        label.setText(toolWrapper.getDisplayName() + " inspection");
        titlePanel.add((Component)label);
        titlePanel.add(Box.createHorizontalStrut(JBUI.scale((int)16)));
        if (!enabled) {
            JBLabel enabledLabel = new JBLabel();
            enabledLabel.setForeground((Color)JBColor.GRAY);
            enabledLabel.setText("Disabled");
            titlePanel.add((Component)enabledLabel);
        }
        this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)new JBInsets(0, 12, 5, 16), 0, 0));
        JEditorPane description = new JEditorPane();
        description.setContentType("text/html");
        description.setEditable(false);
        description.setOpaque(false);
        description.setBackground(UIUtil.getLabelBackground());
        description.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        String toolDescription = toolWrapper.loadDescription();
        SingleInspectionProfilePanel.readHTML(description, SingleInspectionProfilePanel.toHTML(description, toolDescription == null ? "" : toolDescription, false));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)description, (boolean)true);
        this.add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 3, (Insets)new JBInsets(0, 10, 0, 0), this.getFontMetrics(UIUtil.getLabelFont()).charWidth('f') * 110 - pane.getMinimumSize().width, 0));
        JButton enableButton = new JButton((enabled ? "Disable" : "Enable") + " inspection");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionNodeInfo$1", "onClick"));
                }
                DisableInspectionToolAction.modifyAndCommitProjectProfile((Consumer<ModifiableModel>)((Consumer)model -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/InspectionNodeInfo$1", "lambda$onClick$0"));
                    }
                    String toolId = key2.toString();
                    if (enabled) {
                        model.disableTool(toolId, project2);
                    } else {
                        ((InspectionProfileImpl)model).enableTool(toolId, project2);
                    }
                }), project2);
                return true;
            }
        }.installOn((Component)enableButton);
        final JButton runInspectionOnButton = new JButton(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionNodeInfo$2", "onClick"));
                }
                AnAction action = ActionManager.getInstance().getAction("RunInspectionOn");
                action.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", (Presentation)action.getTemplatePresentation(), (DataContext)DataManager.getInstance().getDataContext((Component)runInspectionOnButton)));
                return true;
            }
        }.installOn((Component)runInspectionOnButton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        buttons.add(enableButton);
        buttons.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        buttons.add(runInspectionOnButton);
        this.add((Component)buttons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, (Insets)new JBInsets(15, 9, 9, 0), 0, 0));
    }
}

