/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModuleScopeProvider;
import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreModule
extends MockComponentManager
implements ModuleEx {
    private final String myPath;
    @NotNull
    private final Disposable myLifetime;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ModuleScopeProvider myModuleScopeProvider;

    public CoreModule(@NotNull Disposable parentDisposable, @NotNull Project project2, String moduleFilePath) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreModule", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreModule", "<init>"));
        }
        super(project2.getPicoContainer(), parentDisposable);
        this.myLifetime = parentDisposable;
        this.myProject = project2;
        this.myPath = moduleFilePath;
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.disposeArea((AreaInstance)CoreModule.this);
            }
        });
        this.initModuleExtensions();
        final ModuleRootManagerImpl moduleRootManager = new ModuleRootManagerImpl(this, ProjectRootManagerImpl.getInstanceImpl(project2), VirtualFilePointerManager.getInstance()){

            @Override
            public void loadState(ModuleRootManagerImpl.ModuleRootManagerState object) {
                this.loadState(object, false);
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                moduleRootManager.disposeComponent();
            }
        });
        this.getPicoContainer().registerComponentInstance(ModuleRootManager.class, (Object)moduleRootManager);
        this.getPicoContainer().registerComponentInstance(PathMacroManager.class, (Object)this.createModulePathMacroManager(project2));
        this.getPicoContainer().registerComponentInstance(ModuleFileIndex.class, (Object)this.createModuleFileIndex(project2));
        this.myModuleScopeProvider = this.createModuleScopeProvider();
    }

    protected void initModuleExtensions() {
    }

    protected <T> void addModuleExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)this).getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myLifetime, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    protected ModuleScopeProvider createModuleScopeProvider() {
        return new CoreModuleScopeProvider();
    }

    protected PathMacroManager createModulePathMacroManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreModule", "createModulePathMacroManager"));
        }
        return new ModulePathMacroManager(PathMacros.getInstance(), this);
    }

    protected ModuleFileIndex createModuleFileIndex(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/core/CoreModule", "createModuleFileIndex"));
        }
        return new ModuleFileIndexImpl(this, DirectoryIndex.getInstance(project2));
    }

    @Override
    public void init(@NotNull String path, @Nullable Runnable beforeComponentCreation) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/core/CoreModule", "init"));
        }
    }

    @Override
    public void moduleAdded() {
    }

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    public void rename(String newName) {
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public VirtualFile getModuleFile() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getModuleFilePath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleFilePath"));
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getProject"));
        }
        return project2;
    }

    @NotNull
    public String getName() {
        String string = StringUtil.trimEnd((String)PathUtil.getFileName((String)this.myPath), (String)".iml");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getName"));
        }
        return string;
    }

    public boolean isLoaded() {
        return true;
    }

    public void setOption(@NotNull String optionName, @NotNull String optionValue) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/core/CoreModule", "setOption"));
        }
        if (optionValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionValue", "com/intellij/core/CoreModule", "setOption"));
        }
        throw new UnsupportedOperationException();
    }

    public void clearOption(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/core/CoreModule", "clearOption"));
        }
        throw new UnsupportedOperationException();
    }

    public String getOptionValue(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/core/CoreModule", "getOptionValue"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleContentScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleContentWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleTestsWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModule", "getModuleRuntimeScope"));
        }
        return globalSearchScope;
    }
}

