/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties>
implements JavaBreakpointType<JavaLineBreakpointProperties> {
    public JavaLineBreakpointType() {
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "<init>"));
        }
        super(id, title);
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createBreakpointProperties"));
        }
        JavaLineBreakpointProperties javaLineBreakpointProperties = new JavaLineBreakpointProperties();
        if (javaLineBreakpointProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createBreakpointProperties"));
        }
        return javaLineBreakpointProperties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        LineBreakpoint<JavaLineBreakpointProperties> lineBreakpoint = new LineBreakpoint<JavaLineBreakpointProperties>(project2, breakpoint);
        if (lineBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createJavaBreakpoint"));
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition position) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
        }
        PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(position.getFile());
        if (file2 == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list;
        }
        SourcePosition pos = SourcePosition.createFromLine((PsiFile)file2, (int)position.getLine());
        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(pos, true);
        if (lambdas.isEmpty()) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list;
        }
        PsiElement startMethod = DebuggerUtilsEx.getContainingMethod(pos);
        if (lambdas.contains(startMethod) && lambdas.size() == 1) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list;
        }
        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document2 == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list;
        }
        SmartList res = new SmartList();
        res.add(new JavaBreakpointVariant(position));
        if (!(startMethod instanceof PsiLambdaExpression)) {
            res.add(new ExactJavaBreakpointVariant(position, startMethod, -1));
        }
        int ordinal = 0;
        for (PsiLambdaExpression lambda2 : lambdas) {
            PsiElement firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambda2, document2, position.getLine());
            XSourcePositionImpl elementPosition = XSourcePositionImpl.createByElement(firstElem);
            if (elementPosition == null) continue;
            res.add(new ExactJavaBreakpointVariant(elementPosition, (PsiElement)lambda2, ordinal++));
        }
        SmartList smartList = res;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
        }
        return smartList;
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "matchesPosition"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "matchesPosition"));
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties) {
            if (!(breakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "getContainingMethod"));
        }
        SourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties && !(breakpoint instanceof RunToCursorBreakpoint) && (ordinal = ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal()) > -1) {
            List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(position, true);
            if (ordinal < lambdas.size()) {
                return (PsiElement)lambdas.get(ordinal);
            }
        }
        return DebuggerUtilsEx.getContainingMethod(position);
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        PsiElement method;
        Breakpoint javaBreakpoint;
        Integer ordinal;
        JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)breakpoint.getProperties();
        if (properties != null && (ordinal = properties.getLambdaOrdinal()) != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (method = this.getContainingMethod((LineBreakpoint)javaBreakpoint)) != null) {
            return method.getTextRange();
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement myElement;
        private final Integer myLambdaOrdinal;

        public ExactJavaBreakpointVariant(XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant", "<init>"));
            }
            super(position);
            this.myElement = element;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        public Icon getIcon() {
            return this.myElement.getIcon(0);
        }

        public String getText() {
            return StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0);
        }

        public TextRange getHighlightRange() {
            return this.myElement.getTextRange();
        }

        @NotNull
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.setLambdaOrdinal(this.myLambdaOrdinal);
            JavaLineBreakpointProperties javaLineBreakpointProperties = properties;
            if (javaLineBreakpointProperties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant", "createProperties"));
            }
            return javaLineBreakpointProperties;
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        public JavaBreakpointVariant(XSourcePosition position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant", "<init>"));
            }
            super((XLineBreakpointType)JavaLineBreakpointType.this, position);
        }
    }
}

