/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.jetbrains.annotations.Nullable;

class VelocityWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.VelocityWrapper");
    private static final ThreadLocal<FileTemplateManager> ourTemplateManager = new ThreadLocal();

    VelocityWrapper() {
    }

    static SimpleNode parse(Reader reader, String templateName) throws ParseException {
        return RuntimeSingleton.parse((Reader)reader, (String)templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean evaluate(@Nullable Project project2, Context context, Writer writer, String templateContent) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException {
        try {
            ourTemplateManager.set(project2 == null ? FileTemplateManager.getDefaultInstance() : FileTemplateManager.getInstance(project2));
            boolean bl = Velocity.evaluate((Context)context, (Writer)writer, (String)"", (String)templateContent);
            return bl;
        }
        finally {
            ourTemplateManager.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class<?>[] interfaces = ResourceManagerImpl.class.getInterfaces();
            if (interfaces.length != 1 || !interfaces[0].equals(ResourceManager.class)) {
                throw new IllegalStateException("Incorrect velocity version in the classpath, ResourceManager in " + PathManager.getJarPathForClass(ResourceManager.class) + ", ResourceManagerImpl in " + PathManager.getJarPathForClass(ResourceManagerImpl.class));
            }
            LogSystem emptyLogSystem = new LogSystem(){

                public void init(RuntimeServices runtimeServices) throws Exception {
                }

                public void logVelocityMessage(int i, String s) {
                }
            };
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)emptyLogSystem);
            Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"parser.pool.size", (Object)3);
            Velocity.setProperty((String)"resource.loader", (Object)"includes");
            Velocity.setProperty((String)"includes.resource.loader.instance", (Object)new ResourceLoader(){

                public void init(ExtendedProperties configuration) {
                }

                public InputStream getResourceStream(String resourceName) throws ResourceNotFoundException {
                    FileTemplate include;
                    FileTemplateManager templateManager = (FileTemplateManager)ourTemplateManager.get();
                    if (templateManager == null) {
                        templateManager = FileTemplateManager.getDefaultInstance();
                    }
                    if ((include = templateManager.getPattern(resourceName)) == null) {
                        throw new ResourceNotFoundException("Template not found: " + resourceName);
                    }
                    String text = include.getText();
                    try {
                        return new ByteArrayInputStream(text.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }

                public boolean isSourceModified(Resource resource) {
                    return true;
                }

                public long getLastModified(Resource resource) {
                    return 0L;
                }
            });
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            Application application = ApplicationManager.getApplication();
            if (application.isInternal() && !application.isUnitTestMode() && SystemInfo.isJavaVersionAtLeast((String)"1.6.0_33") && SystemInfo.isAppleJvm) {
                thread.setContextClassLoader(FileTemplate.class.getClassLoader());
            }
            try {
                Velocity.init();
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to init Velocity", (Throwable)e);
        }
    }
}

