/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectBaseDirNavigationContributor
implements ChooseByNameContributor,
DumbAware {
    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ProjectBaseDirNavigationContributor", "getNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        VirtualFile[] files = baseDir.getChildren();
        ArrayList<String> list = new ArrayList<String>();
        for (VirtualFile file2 : files) {
            if (file2.isDirectory()) continue;
            list.add(file2.getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(list);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ProjectBaseDirNavigationContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project2, boolean includeNonProjectItems) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir == null) {
            if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ProjectBaseDirNavigationContributor", "getItemsByName"));
            }
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        VirtualFile[] files = baseDir.getChildren();
        ArrayList<PsiFile> list = new ArrayList<PsiFile>();
        for (VirtualFile file2 : files) {
            PsiFile psiFile;
            if (!ProjectBaseDirNavigationContributor.isEditable(file2, includeNonProjectItems) || !Comparing.strEqual((String)name, (String)file2.getName()) || (psiFile = psiManager.findFile(file2)) == null) continue;
            list.add(psiFile);
        }
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(list);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ProjectBaseDirNavigationContributor", "getItemsByName"));
        }
        return psiFileArray;
    }

    private static boolean isEditable(VirtualFile file2, boolean checkboxState) {
        FileType type = file2.getFileType();
        if (!checkboxState && type == StdFileTypes.JAVA) {
            return false;
        }
        return type != StdFileTypes.CLASS;
    }
}

