/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import org.jetbrains.annotations.NotNull;

public class LineStartWithSelectionAction
extends TextComponentEditorAction {
    public LineStartWithSelectionAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        public Handler() {
            super(true);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/LineStartWithSelectionAction$Handler", "isEnabledForCaret"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actions/LineStartWithSelectionAction$Handler", "isEnabledForCaret"));
            }
            return !ModifierKeyDoubleClickHandler.getInstance().isRunningAction() || EditorSettingsExternalizable.getInstance().addCaretsOnDoubleCtrl();
        }

        public void doExecute(Editor editor, Caret caret, DataContext dataContext) {
            EditorActionUtil.moveCaretToLineStart(editor, true);
        }
    }
}

