/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentMarkupModel {
    private static final Key<MarkupModelEx> MARKUP_MODEL_KEY = Key.create((String)"DocumentMarkupModel.MarkupModel");
    private static final Key<ConcurrentMap<Project, MarkupModelImpl>> MARKUP_MODEL_MAP_KEY = Key.create((String)"DocumentMarkupModel.MarkupModelMap");

    private DocumentMarkupModel() {
    }

    public static MarkupModel forDocument(@NotNull Document document2, @Nullable Project project2, boolean create) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/DocumentMarkupModel", "forDocument"));
        }
        if (document2 instanceof DocumentWindow) {
            Document delegate = ((DocumentWindow)document2).getDelegate();
            MarkupModelEx baseMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(delegate, project2, true);
            return new MarkupModelWindow(baseMarkupModel, (DocumentWindow)document2);
        }
        if (project2 == null) {
            MarkupModelImpl newModel;
            MarkupModelEx markupModel = (MarkupModelEx)document2.getUserData(MARKUP_MODEL_KEY);
            if (create && markupModel == null && (markupModel = (MarkupModelEx)((UserDataHolderEx)document2).putUserDataIfAbsent(MARKUP_MODEL_KEY, (Object)(newModel = new MarkupModelImpl((DocumentEx)document2)))) != newModel) {
                newModel.dispose();
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project2.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project2);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed() || project2.isDisposed()) {
            return new EmptyMarkupModel(document2);
        }
        ConcurrentMap<Project, MarkupModelImpl> markupModelMap = DocumentMarkupModel.getMarkupModelMap(document2);
        MarkupModelImpl model = (MarkupModelImpl)markupModelMap.get(project2);
        if (create && model == null) {
            MarkupModelImpl newModel = new MarkupModelImpl((DocumentEx)document2);
            model = (MarkupModelImpl)ConcurrencyUtil.cacheOrGet(markupModelMap, (Object)project2, (Object)newModel);
            if (model == newModel) {
                documentMarkupModelManager.registerDocument(document2);
            } else {
                newModel.dispose();
            }
        }
        return model;
    }

    private static ConcurrentMap<Project, MarkupModelImpl> getMarkupModelMap(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/DocumentMarkupModel", "getMarkupModelMap"));
        }
        ConcurrentMap markupModelMap = (ConcurrentMap)document2.getUserData(MARKUP_MODEL_MAP_KEY);
        if (markupModelMap == null) {
            ConcurrentMap newMap = ContainerUtil.newConcurrentMap();
            markupModelMap = (ConcurrentMap)((UserDataHolderEx)document2).putUserDataIfAbsent(MARKUP_MODEL_MAP_KEY, (Object)newMap);
        }
        return markupModelMap;
    }

    static void removeMarkupModel(@NotNull Document document2, @NotNull Project project2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/DocumentMarkupModel", "removeMarkupModel"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/impl/DocumentMarkupModel", "removeMarkupModel"));
        }
        MarkupModelImpl removed = (MarkupModelImpl)DocumentMarkupModel.getMarkupModelMap(document2).remove(project2);
        if (removed != null) {
            removed.dispose();
        }
    }
}

