/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeMarker
extends RangeMarkerImpl {
    private LinesCols myLinesCols;

    PersistentRangeMarker(DocumentEx document2, int startOffset, int endOffset, boolean register) {
        super(document2, startOffset, endOffset, register);
        this.myLinesCols = (LinesCols)ObjectUtils.assertNotNull((Object)PersistentRangeMarker.storeLinesAndCols(document2, this.getStartOffset(), this.getEndOffset()));
    }

    @Nullable
    static LinesCols storeLinesAndCols(Document myDocument, int startOffset, int endOffset) {
        int myEndColumn;
        int myEndLine;
        int myStartColumn;
        int myStartLine;
        if (startOffset <= myDocument.getTextLength()) {
            myStartLine = myDocument.getLineNumber(startOffset);
            myStartColumn = startOffset - myDocument.getLineStartOffset(myStartLine);
            if (myStartColumn < 0) {
                return null;
            }
        } else {
            return null;
        }
        if (endOffset <= myDocument.getTextLength()) {
            myEndLine = myDocument.getLineNumber(endOffset);
            myEndColumn = endOffset - myDocument.getLineStartOffset(myEndLine);
            if (myEndColumn < 0) {
                return null;
            }
        } else {
            return null;
        }
        return new LinesCols(myStartLine, myStartColumn, myEndLine, myEndColumn);
    }

    @Nullable
    static Pair<TextRange, LinesCols> translateViaDiff(@NotNull DocumentEventImpl event, @NotNull LinesCols linesCols) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/PersistentRangeMarker", "translateViaDiff"));
        }
        if (linesCols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linesCols", "com/intellij/openapi/editor/impl/PersistentRangeMarker", "translateViaDiff"));
        }
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document2 = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document2.getLineCount()) {
                return null;
            }
            int start = document2.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start >= document2.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document2.getLineCount()) {
                return null;
            }
            int end = document2.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document2.getTextLength() || end < start) {
                return null;
            }
            if (end > event.getDocument().getTextLength() || myEndLine < myStartLine || myStartLine == myEndLine && linesCols.myEndColumn < linesCols.myStartColumn || event.getDocument().getLineCount() < myEndLine) {
                return null;
            }
            return Pair.create((Object)new TextRange(start, end), (Object)new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/PersistentRangeMarker", "changedUpdateImpl"));
        }
        if (!this.isValid()) {
            return;
        }
        Pair<TextRange, LinesCols> pair = PersistentRangeMarker.applyChange(e, this, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.myLinesCols);
        if (pair == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(((TextRange)pair.first).getStartOffset());
        this.setIntervalEnd(((TextRange)pair.first).getEndOffset());
        this.myLinesCols = (LinesCols)pair.second;
    }

    @Nullable
    private static Pair<TextRange, LinesCols> applyChange(DocumentEvent event, Segment range, int intervalStart, int intervalEnd, boolean greedyLeft, boolean greedyRight, LinesCols linesCols) {
        boolean shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, range.getStartOffset(), range.getEndOffset());
        Pair translated = null;
        if (shouldTranslateViaDiff) {
            translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
        }
        if (translated == null) {
            TextRange fallback = PersistentRangeMarker.applyChange(event, intervalStart, intervalEnd, greedyLeft, greedyRight);
            if (fallback == null) {
                return null;
            }
            LinesCols lc = PersistentRangeMarker.storeLinesAndCols(event.getDocument(), fallback.getStartOffset(), fallback.getEndOffset());
            if (lc == null) {
                return null;
            }
            translated = Pair.create((Object)fallback, (Object)lc);
        }
        return translated;
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    static class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }
}

