/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.JavaPsiFacade;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaModuleType
extends ModuleType<JavaModuleBuilder> {
    public static final String MODULE_NAME = ProjectBundle.message((String)"module.type.java.name", (Object[])new Object[0]);
    public static final String JAVA_GROUP = "Java";
    public static final String BUILD_TOOLS_GROUP = "Build Tools";
    public static final String MOBILE_GROUP = "Mobile Java";
    private static final String JAVA_MODULE = "JAVA_MODULE";

    public static ModuleType getModuleType() {
        return ModuleTypeManager.getInstance().findByID(JAVA_MODULE);
    }

    public JavaModuleType() {
        this(JAVA_MODULE);
    }

    protected JavaModuleType(@NonNls String id) {
        super(id);
    }

    @NotNull
    public JavaModuleBuilder createModuleBuilder() {
        JavaModuleBuilder javaModuleBuilder = new JavaModuleBuilder();
        if (javaModuleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/JavaModuleType", "createModuleBuilder"));
        }
        return javaModuleBuilder;
    }

    @NotNull
    public String getName() {
        String string = MODULE_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/JavaModuleType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = ProjectBundle.message((String)"module.type.java.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/JavaModuleType", "getDescription"));
        }
        return string;
    }

    public Icon getBigIcon() {
        return JavaModuleType.getJavaModuleIcon();
    }

    public Icon getNodeIcon(boolean isOpened) {
        return JavaModuleType.getJavaModuleNodeIconClosed();
    }

    @Nullable
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/openapi/module/JavaModuleType", "modifyProjectTypeStep"));
        }
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/openapi/module/JavaModuleType", "modifyProjectTypeStep"));
        }
        return ProjectWizardStepFactory.getInstance().createJavaSettingsStep(settingsStep, moduleBuilder, sdkType -> {
            if (moduleBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/openapi/module/JavaModuleType", "lambda$modifyProjectTypeStep$0"));
            }
            return moduleBuilder.isSuitableSdkType(sdkType);
        });
    }

    private static Icon getJavaModuleIcon() {
        return AllIcons.Modules.Types.JavaModule;
    }

    private static Icon getJavaModuleNodeIconClosed() {
        return AllIcons.Nodes.Module;
    }

    public boolean isValidSdk(@NotNull Module module2, Sdk projectSdk) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/JavaModuleType", "isValidSdk"));
        }
        return JavaModuleType.isValidJavaSdk(module2);
    }

    public static boolean isValidJavaSdk(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/JavaModuleType", "isValidJavaSdk"));
        }
        if (ModuleRootManager.getInstance((Module)module2).getSourceRoots(JavaModuleSourceRootTypes.SOURCES).isEmpty()) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findClass("java.lang.Object", module2.getModuleWithLibrariesScope()) != null;
    }
}

