/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache = ContainerUtil.newConcurrentMap();
    private final Set<String> myNonExistentPackages = ContainerUtil.newConcurrentSet();
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        @Override
        public void run() {
            PackageDirectoryCache.this.myNonExistentPackages.clear();
        }
    });

    public PackageDirectoryCache(MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        this.myRootsByPackagePrefix = rootsByPackagePrefix;
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/PackageDirectoryCache", "getDirectoriesByPackageName"));
        }
        PackageInfo info = this.getPackageInfo(packageName);
        List<Object> list = info == null ? Collections.emptyList() : info.myPackageDirectories;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/PackageDirectoryCache", "getDirectoriesByPackageName"));
        }
        return list;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/PackageDirectoryCache", "getPackageInfo"));
        }
        PackageInfo info = this.myDirectoriesByPackageNameCache.get(packageName);
        if (info == null) {
            if (this.myNonExistentPackages.contains(packageName)) {
                return null;
            }
            if (packageName.length() > Registry.intValue((String)"java.max.package.name.length") || StringUtil.containsAnyChar((String)packageName, (String)";[/")) {
                return null;
            }
            List result2 = ContainerUtil.newSmartList();
            if (StringUtil.isNotEmpty((String)packageName) && !StringUtil.startsWithChar((CharSequence)packageName, (char)'.')) {
                int i = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName.substring(0, i) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName.lastIndexOf(46, i - 1);
                }
            }
            for (VirtualFile file2 : this.myRootsByPackagePrefix.get((Object)packageName)) {
                if (!file2.isDirectory()) continue;
                result2.add(file2);
            }
            if (!result2.isEmpty()) {
                info = new PackageInfo(packageName, result2);
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    public Set<String> getSubpackageNames(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/PackageDirectoryCache", "getSubpackageNames"));
        }
        PackageInfo info = this.getPackageInfo(packageName);
        return info == null ? Collections.emptySet() : Collections.unmodifiableSet(((MultiMap)info.mySubPackages.getValue()).keySet());
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/PackageDirectoryCache", "isPackageDirectory"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/PackageDirectoryCache", "isPackageDirectory"));
        }
        return true;
    }

    private class PackageInfo {
        final String myQname;
        final List<VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages = new VolatileNotNullLazyValue<MultiMap<String, VirtualFile>>(){

            @NotNull
            protected MultiMap<String, VirtualFile> compute() {
                MultiMap result2 = MultiMap.createLinked();
                for (VirtualFile directory : PackageInfo.this.myPackageDirectories) {
                    for (VirtualFile child : directory.getChildren()) {
                        String packageName;
                        String childName = child.getName();
                        String string = packageName = PackageInfo.this.myQname.isEmpty() ? childName : PackageInfo.this.myQname + "." + childName;
                        if (!child.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child, packageName)) continue;
                        result2.putValue((Object)childName, (Object)child);
                    }
                }
                MultiMap multiMap = result2;
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo$1", "compute"));
                }
                return multiMap;
            }
        };

        PackageInfo(String qname, List<VirtualFile> packageDirectories) {
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection collection = ((MultiMap)this.mySubPackages.getValue()).get((Object)shortName);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo", "getSubPackageDirectories"));
            }
            return collection;
        }
    }
}

