/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryPropertiesEditorBase<P extends LibraryProperties, T extends LibraryType<P>>
extends LibraryPropertiesEditor {
    private JPanel myMainPanel;
    private JLabel myDescriptionLabel;
    private JButton myEditButton;
    private boolean myModified;
    protected final LibraryEditorComponent<P> myEditorComponent;
    protected final T myLibraryType;

    protected LibraryPropertiesEditorBase(LibraryEditorComponent<P> editorComponent, T libraryType, @Nullable String editButtonText) {
        this.myEditorComponent = editorComponent;
        this.myLibraryType = libraryType;
        this.$$$setupUI$$$();
        this.updateDescription();
        if (editButtonText != null) {
            this.myEditButton.setText(UIUtil.replaceMnemonicAmpersand((String)editButtonText));
        }
        this.myEditButton.setVisible(!this.myEditorComponent.isNewLibrary());
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryPropertiesEditorBase.this.edit();
            }
        });
    }

    protected JPanel getMainPanel() {
        return this.myMainPanel;
    }

    protected void updateDescription() {
        this.myDescriptionLabel.setText(((LibraryPresentationProvider)this.myLibraryType).getDescription(this.myEditorComponent.getProperties()));
    }

    protected abstract void edit();

    protected void setModified() {
        this.myModified = true;
        this.updateDescription();
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryPropertiesEditorBase", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void reset() {
        this.updateDescription();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEditButton = jButton = new JButton();
        jButton.setText("Edit...");
        jButton.setMnemonic('E');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

