/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBackgroundableComputable<T>
extends Task.Backgroundable {
    private final String myErrorTitle;
    private boolean mySilent;
    private final Project myProject;
    private final BackgroundableActionEnabledHandler myHandler;
    private final Object myActionParameter;
    private final ThrowableComputable<T, VcsException> myBackgroundable;
    private final Consumer<T> myAwtSuccessContinuation;
    private final Runnable myAwtErrorContinuation;
    private VcsException myException;
    private T myResult;

    private VcsBackgroundableComputable(Project project2, String title, String errorTitle, ThrowableComputable<T, VcsException> backgroundable, Consumer<T> awtSuccessContinuation, Runnable awtErrorContinuation, BackgroundableActionEnabledHandler handler2, Object actionParameter) {
        super(project2, title, true);
        this.myErrorTitle = errorTitle;
        this.myBackgroundable = backgroundable;
        this.myAwtSuccessContinuation = awtSuccessContinuation;
        this.myAwtErrorContinuation = awtErrorContinuation;
        this.myProject = project2;
        this.myHandler = handler2;
        this.myActionParameter = actionParameter;
    }

    public static <T> void createAndRunSilent(Project project2, @Nullable VcsBackgroundableActions actionKey, @Nullable Object actionParameter, String title, ThrowableComputable<T, VcsException> backgroundable, @Nullable Consumer<T> awtSuccessContinuation) {
        VcsBackgroundableComputable.createAndRun(project2, actionKey, actionParameter, title, null, backgroundable, awtSuccessContinuation, null, true);
    }

    public static <T> void createAndRun(Project project2, @Nullable VcsBackgroundableActions actionKey, @Nullable Object actionParameter, String title, String errorTitle, ThrowableComputable<T, VcsException> backgroundable) {
        VcsBackgroundableComputable.createAndRun(project2, actionKey, actionParameter, title, errorTitle, backgroundable, null, null);
    }

    public static <T> void createAndRun(Project project2, @Nullable VcsBackgroundableActions actionKey, @Nullable Object actionParameter, String title, String errorTitle, ThrowableComputable<T, VcsException> backgroundable, @Nullable Consumer<T> awtSuccessContinuation, @Nullable Runnable awtErrorContinuation) {
        VcsBackgroundableComputable.createAndRun(project2, actionKey, actionParameter, title, errorTitle, backgroundable, awtSuccessContinuation, awtErrorContinuation, false);
    }

    private static <T> void createAndRun(Project project2, @Nullable VcsBackgroundableActions actionKey, @Nullable Object actionParameter, String title, String errorTitle, ThrowableComputable<T, VcsException> backgroundable, @Nullable Consumer<T> awtSuccessContinuation, @Nullable Runnable awtErrorContinuation, boolean silent) {
        BackgroundableActionEnabledHandler handler2;
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project2);
        if (actionKey != null) {
            handler2 = vcsManager.getBackgroundableActionHandler(actionKey);
            if (handler2.isInProgress(actionParameter)) {
                return;
            }
        } else {
            handler2 = null;
        }
        VcsBackgroundableComputable<T> backgroundableComputable = new VcsBackgroundableComputable<T>(project2, title, errorTitle, backgroundable, awtSuccessContinuation, awtErrorContinuation, handler2, actionParameter);
        backgroundableComputable.setSilent(silent);
        if (handler2 != null) {
            handler2.register(actionParameter);
        }
        ProgressManager.getInstance().run(backgroundableComputable);
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/VcsBackgroundableComputable", "run"));
        }
        try {
            this.myResult = this.myBackgroundable.compute();
        }
        catch (VcsException e) {
            this.myException = e;
        }
    }

    public void onCancel() {
        this.commonFinish();
    }

    public void onSuccess() {
        this.commonFinish();
        if (this.myException == null) {
            if (this.myAwtSuccessContinuation != null) {
                this.myAwtSuccessContinuation.consume(this.myResult);
            }
        } else if (this.myAwtErrorContinuation != null) {
            this.myAwtErrorContinuation.run();
        }
    }

    private void commonFinish() {
        if (this.myHandler != null) {
            this.myHandler.completed(this.myActionParameter);
        }
        if (!this.mySilent && this.myException != null) {
            AbstractVcsHelperImpl.getInstance((Project)this.myProject).showError(this.myException, this.myErrorTitle);
        }
    }

    public void setSilent(boolean silent) {
        this.mySilent = silent;
    }
}

