/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RequestsMerger;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestModifier;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.Consumer;

public class FileWatchRequestsManager {
    private final RequestsMerger myMerger;
    private final Project myProject;

    public FileWatchRequestsManager(Project project2, NewMappings newMappings, LocalFileSystem localFileSystem) {
        this.myProject = project2;
        this.myMerger = new RequestsMerger(new FileWatchRequestModifier(project2, newMappings, localFileSystem), new Consumer<Runnable>(){

            public void consume(Runnable runnable2) {
                if (!FileWatchRequestsManager.this.myProject.isInitialized() || FileWatchRequestsManager.this.myProject.isDisposed()) {
                    return;
                }
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    runnable2.run();
                } else {
                    application.executeOnPooledThread(runnable2);
                }
            }
        });
    }

    public void ping() {
        this.myMerger.request();
    }
}

