/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

class VirtualFilePointerImpl
extends TraceableDisposable
implements VirtualFilePointer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerImpl");
    private final VirtualFilePointerListener myListener;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    volatile FilePointerPartNode myNode;

    VirtualFilePointerImpl(VirtualFilePointerListener listener2, @NotNull Disposable parentDisposable, Pair<VirtualFile, String> fileAndUrl) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "<init>"));
        }
        super(TRACE_CREATION);
        this.myListener = listener2;
    }

    @NotNull
    public String getFileName() {
        if (!this.checkDisposed()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getFileName"));
            }
            return "";
        }
        Pair<VirtualFile, String> result2 = this.myNode.update();
        VirtualFile file2 = (VirtualFile)result2.first;
        if (file2 != null) {
            String string = file2.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getFileName"));
            }
            return string;
        }
        String url = (String)result2.second;
        int index = url.lastIndexOf(47);
        String string = index >= 0 ? url.substring(index + 1) : url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getFileName"));
        }
        return string;
    }

    public VirtualFile getFile() {
        if (!this.checkDisposed()) {
            return null;
        }
        Pair<VirtualFile, String> result2 = this.myNode.update();
        return (VirtualFile)result2.first;
    }

    @NotNull
    public String getUrl() {
        if (this.isDisposed()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getUrl"));
            }
            return "";
        }
        Pair<VirtualFile, String> update = this.myNode.update();
        String string = (String)update.second;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getUrl"));
        }
        return string;
    }

    @NotNull
    String getUrlNoUpdate() {
        String string = this.isDisposed() ? "" : (String)this.myNode.myFileAndUrl.second;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getUrlNoUpdate"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        if (!this.checkDisposed()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getPresentableUrl"));
            }
            return "";
        }
        String string = PathUtil.toPresentableUrl((String)this.getUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl", "getPresentableUrl"));
        }
        return string;
    }

    private boolean checkDisposed() {
        if (this.isDisposed()) {
            ProgressManager.checkCanceled();
            LOG.error("Already disposed: URL='" + (Object)((Object)this) + "'");
            return false;
        }
        return true;
    }

    public boolean isValid() {
        Pair<VirtualFile, String> result2 = this.isDisposed() ? null : this.myNode.update();
        return result2 != null && result2.first != null;
    }

    public String toString() {
        return this.getUrlNoUpdate();
    }

    public void dispose() {
        this.checkDisposed();
        if (this.myNode.incrementUsageCount(-1) == 0) {
            this.kill("URL when die: " + this.toString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            if (pointerManager instanceof VirtualFilePointerManagerImpl) {
                ((VirtualFilePointerManagerImpl)pointerManager).removeNode(this.myNode, this.myListener);
            }
            this.myNode = null;
        }
    }

    public boolean isDisposed() {
        return this.myNode == null;
    }

    VirtualFilePointerListener getListener() {
        return this.myListener;
    }
}

