/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.events.XmlDocumentChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class XmlDocumentChangedImpl
implements XmlDocumentChanged {
    private final XmlDocument myDocument;

    public XmlDocumentChangedImpl(@NotNull XmlDocument document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/pom/xml/impl/events/XmlDocumentChangedImpl", "<init>"));
        }
        this.myDocument = document2;
    }

    public XmlDocument getDocument() {
        return this.myDocument;
    }

    public static PomModelEvent createXmlDocumentChanged(PomModel source, XmlDocument document2) {
        PomModelEvent event = new PomModelEvent(source);
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)document2, XmlFile.class);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source, xmlFile);
        xmlAspectChangeSet.add((XmlChange)new XmlDocumentChangedImpl(document2));
        event.registerChangeSet(source.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "Xml document changed";
    }
}

