/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDComment {
    protected final CommentFormatter myFormatter;
    private String myDescription;
    private List<String> myUnknownList;
    private List<String> mySeeAlsoList;
    private String mySince;
    private String myDeprecated;
    private boolean myMultiLineComment;
    private String myFirstLine;
    private String myEndLine;

    public JDComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "<init>"));
        }
        this.myFirstLine = "/**";
        this.myEndLine = "*/";
        this.myFormatter = formatter;
    }

    protected static boolean isNull(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    protected static boolean isNull(@Nullable List<?> l) {
        return l == null || l.isEmpty();
    }

    public void setMultiLine(boolean value) {
        this.myMultiLineComment = value;
    }

    @Nullable
    public String generate(@NotNull String indent) {
        JDTag tag;
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "generate"));
        }
        String prefix = this.myFormatter.getSettings().JD_LEADING_ASTERISKS_ARE_ENABLED ? indent + " * " : indent;
        StringBuilder sb = new StringBuilder();
        int start = sb.length();
        if (!JDComment.isNull(this.myDescription)) {
            sb.append(prefix);
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myDescription, prefix, false));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_DESCRIPTION) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        this.generateSpecial(prefix, sb);
        if (!JDComment.isNull(this.myUnknownList) && this.myFormatter.getSettings().JD_KEEP_INVALID_TAGS) {
            for (String string : this.myUnknownList) {
                sb.append(prefix);
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(string, prefix));
            }
        }
        if (!JDComment.isNull(this.mySeeAlsoList)) {
            tag = JDTag.SEE;
            for (String aSeeAlsoList : this.mySeeAlsoList) {
                sb.append(prefix);
                sb.append(tag.getWithEndWhitespace());
                StringBuilder tagDescription2 = this.myFormatter.getParser().formatJDTagDescription(aSeeAlsoList, prefix, true, tag.getDescriptionPrefix(prefix).length());
                sb.append((CharSequence)tagDescription2);
            }
        }
        if (!JDComment.isNull(this.mySince)) {
            tag = JDTag.SINCE;
            sb.append(prefix);
            sb.append(tag.getWithEndWhitespace());
            StringBuilder stringBuilder = this.myFormatter.getParser().formatJDTagDescription(this.mySince, prefix, true, tag.getDescriptionPrefix(prefix).length());
            sb.append((CharSequence)stringBuilder);
        }
        if (this.myDeprecated != null) {
            tag = JDTag.DEPRECATED;
            sb.append(prefix);
            sb.append(tag.getWithEndWhitespace());
            StringBuilder stringBuilder = this.myFormatter.getParser().formatJDTagDescription(this.myDeprecated, prefix, true, tag.getDescriptionPrefix(prefix).length());
            sb.append((CharSequence)stringBuilder);
        }
        if (sb.length() == start) {
            return null;
        }
        int nlen = sb.length() - prefix.length() - 1;
        if (sb.substring(nlen, sb.length()).equals(prefix + "\n")) {
            sb.delete(nlen, sb.length());
        }
        if (this.myMultiLineComment && this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || !this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || sb.indexOf("\n") != sb.length() - 1) {
            sb.insert(0, this.myFirstLine + '\n');
            sb.append(indent);
        } else {
            sb.replace(0, prefix.length(), this.myFirstLine + " ");
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(' ').append(this.myEndLine);
        return sb.toString();
    }

    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "generateSpecial"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "generateSpecial"));
        }
    }

    public void setFirstCommentLine(@NotNull String firstCommentLine) {
        if (firstCommentLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstCommentLine", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "setFirstCommentLine"));
        }
        this.myFirstLine = firstCommentLine;
    }

    public void setLastCommentLine(@NotNull String lastCommentLine) {
        if (lastCommentLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommentLine", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "setLastCommentLine"));
        }
        this.myEndLine = lastCommentLine;
    }

    public void addSeeAlso(@NotNull String seeAlso) {
        if (seeAlso == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seeAlso", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "addSeeAlso"));
        }
        if (this.mySeeAlsoList == null) {
            this.mySeeAlsoList = ContainerUtilRt.newArrayList();
        }
        this.mySeeAlsoList.add(seeAlso);
    }

    public void addUnknownTag(@NotNull String unknownTag) {
        if (unknownTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownTag", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "addUnknownTag"));
        }
        if (this.myUnknownList == null) {
            this.myUnknownList = ContainerUtilRt.newArrayList();
        }
        this.myUnknownList.add(unknownTag);
    }

    public void setSince(@Nullable String since) {
        this.mySince = since;
    }

    public void setDeprecated(@Nullable String deprecated) {
        this.myDeprecated = deprecated;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }
}

