/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceStaticImportUsageInfo
extends FixableUsageInfo {
    private final PsiImportStaticStatement myStaticImportStatement;
    private final PsiClass[] myTargetClasses;

    public ReplaceStaticImportUsageInfo(PsiImportStaticStatement staticImportStatement, PsiClass[] targetClass) {
        super((PsiElement)staticImportStatement);
        this.myStaticImportStatement = staticImportStatement;
        this.myTargetClasses = targetClass;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String memberName = this.myStaticImportStatement.getReferenceName();
        this.myStaticImportStatement.replace((PsiElement)JavaPsiFacade.getInstance((Project)this.myStaticImportStatement.getProject()).getElementFactory().createImportStaticStatement(this.myTargetClasses[0], memberName != null ? memberName : "*"));
    }

    @Override
    public String getConflictMessage() {
        if (this.myTargetClasses.length != 1) {
            return "Static import can be replaced with any of " + StringUtil.join((Object[])this.myTargetClasses, psiClass -> psiClass.getQualifiedName(), (String)", ");
        }
        return super.getConflictMessage();
    }
}

