/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import gnu.trove.THashSet;

abstract class OptimizingSearchHelperBase
implements OptimizingSearchHelper {
    private final THashSet<String> scanned;
    private final THashSet<String> scannedText;
    private final THashSet<String> scannedComments;
    private final THashSet<String> scannedLiterals;
    protected int scanRequest;
    protected final CompileContext context;

    OptimizingSearchHelperBase(CompileContext _context) {
        this.context = _context;
        this.scanRequest = 0;
        this.scanned = new THashSet();
        this.scannedText = new THashSet();
        this.scannedComments = new THashSet();
        this.scannedLiterals = new THashSet();
    }

    @Override
    public void clear() {
        this.scanned.clear();
        this.scannedComments.clear();
        this.scannedLiterals.clear();
    }

    @Override
    public boolean addWordToSearchInCode(String refname) {
        if (!this.scanned.contains((Object)refname)) {
            this.doAddSearchWordInCode(refname);
            this.scanned.add((Object)refname);
            return true;
        }
        return false;
    }

    @Override
    public boolean addWordToSearchInText(String refname) {
        if (!this.scannedText.contains((Object)refname)) {
            this.doAddSearchWordInText(refname);
            this.scannedText.add((Object)refname);
            return true;
        }
        return false;
    }

    protected abstract void doAddSearchWordInCode(String var1);

    protected abstract void doAddSearchWordInText(String var1);

    protected abstract void doAddSearchWordInComments(String var1);

    protected abstract void doAddSearchWordInLiterals(String var1);

    @Override
    public void endTransaction() {
        ++this.scanRequest;
    }

    @Override
    public boolean addWordToSearchInComments(String refname) {
        if (!this.scannedComments.contains((Object)refname)) {
            this.doAddSearchWordInComments(refname);
            this.scannedComments.add((Object)refname);
            return true;
        }
        return false;
    }

    @Override
    public boolean addWordToSearchInLiterals(String refname) {
        if (!this.scannedLiterals.contains((Object)refname)) {
            this.doAddSearchWordInLiterals(refname);
            this.scannedLiterals.add((Object)refname);
            return true;
        }
        return false;
    }

    @Override
    public boolean isScannedSomething() {
        return this.scanned.size() > 0 || this.scannedComments.size() > 0 || this.scannedLiterals.size() > 0;
    }
}

