/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class ModuleFixtureBuilderImpl<T extends ModuleFixture>
implements ModuleFixtureBuilder<T> {
    private static int ourIndex;
    private final ModuleType myModuleType;
    protected final List<String> myContentRoots;
    protected final List<String> mySourceRoots;
    protected final TestFixtureBuilder<? extends IdeaProjectTestFixture> myFixtureBuilder;
    private T myModuleFixture;
    protected String myOutputPath;
    protected String myTestOutputPath;

    public ModuleFixtureBuilderImpl(@NotNull ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/testFramework/fixtures/impl/ModuleFixtureBuilderImpl", "<init>"));
        }
        this.myContentRoots = new ArrayList<String>();
        this.mySourceRoots = new ArrayList<String>();
        this.myModuleType = moduleType;
        this.myFixtureBuilder = fixtureBuilder;
    }

    @Override
    public ModuleFixtureBuilder<T> addContentRoot(String contentRootPath) {
        this.myContentRoots.add(contentRootPath);
        return this;
    }

    @Override
    public ModuleFixtureBuilder<T> addSourceRoot(String sourceRootPath) {
        Assert.assertFalse((String)"content root should be added first", (boolean)this.myContentRoots.isEmpty());
        this.mySourceRoots.add(sourceRootPath);
        return this;
    }

    @Override
    public void setOutputPath(String outputPath) {
        this.myOutputPath = outputPath;
    }

    @Override
    public void setTestOutputPath(String outputPath) {
        this.myTestOutputPath = outputPath;
    }

    protected Module createModule() {
        Project project2 = this.myFixtureBuilder.getFixture().getProject();
        Assert.assertNotNull((Object)project2);
        String moduleFilePath = PathUtil.getParentPath((String)project2.getBasePath()) + "/" + ModuleFixtureBuilderImpl.getNextIndex() + ".iml";
        return ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, this.myModuleType.getId());
    }

    private static int getNextIndex() {
        return ourIndex++;
    }

    @Override
    public synchronized T getFixture() {
        if (this.myModuleFixture == null) {
            this.myModuleFixture = this.instantiateFixture();
        }
        return this.myModuleFixture;
    }

    @Override
    public void addSourceContentRoot(String path) {
        this.addContentRoot(path);
        this.addSourceRoot(path);
    }

    protected abstract T instantiateFixture();

    Module buildModule() {
        Module[] module2 = new Module[]{null};
        ApplicationManager.getApplication().runWriteAction(() -> {
            module2[0] = this.createModule();
            this.initModule(module2[0]);
        });
        return module2[0];
    }

    protected void initModule(Module module2) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        for (String contentRoot : this.myContentRoots) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentRoot);
            Assert.assertNotNull((String)("cannot find content root: " + contentRoot), (Object)virtualFile);
            ContentEntry contentEntry = rootModel.addContentEntry(virtualFile);
            for (String sourceRoot : this.mySourceRoots) {
                VirtualFile file2;
                String s = contentRoot + "/" + sourceRoot;
                VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(s);
                if (vf == null && (file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourceRoot)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) {
                    vf = file2;
                }
                if (vf != null) {
                    contentEntry.addSourceFolder(vf, false);
                    continue;
                }
                contentEntry.addSourceFolder(VfsUtilCore.pathToUrl((String)s), false);
            }
        }
        this.setupRootModel(rootModel);
        rootModel.commit();
    }

    protected void setupRootModel(ModifiableRootModel rootModel) {
    }
}

