/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInBulk(@NotNull Document document2, boolean executeInBulk, @NotNull Runnable task) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "executeInBulk"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/DocumentUtil", "executeInBulk"));
        }
        if (!(document2 instanceof DocumentEx)) {
            task.run();
            return;
        }
        DocumentEx documentEx = (DocumentEx)document2;
        if (executeInBulk == documentEx.isInBulkUpdate()) {
            task.run();
            return;
        }
        documentEx.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            documentEx.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            documentEx.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void writeInRunUndoTransparentAction(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/DocumentUtil", "writeInRunUndoTransparentAction"));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }
        });
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document2, int line) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getFirstNonSpaceCharOffset"));
        }
        int startOffset = document2.getLineStartOffset(line);
        int endOffset = document2.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document2, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document2, int startOffset, int endOffset) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getFirstNonSpaceCharOffset"));
        }
        CharSequence text = document2.getImmutableCharSequence();
        for (int i = startOffset; i < endOffset; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isValidOffset"));
        }
        return offset >= 0 && offset <= document2.getTextLength();
    }

    public static int getLineStartOffset(int offset, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getLineStartOffset"));
        }
        if (offset < 0 || offset > document2.getTextLength()) {
            return offset;
        }
        int lineNumber = document2.getLineNumber(offset);
        return document2.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getLineEndOffset"));
        }
        if (offset < 0 || offset > document2.getTextLength()) {
            return offset;
        }
        int lineNumber = document2.getLineNumber(offset);
        return document2.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document2, int line) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getLineTextRange"));
        }
        TextRange textRange = TextRange.create((int)document2.getLineStartOffset(line), (int)document2.getLineEndOffset(line));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/DocumentUtil", "getLineTextRange"));
        }
        return textRange;
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isAtLineStart"));
        }
        return offset >= 0 && offset <= document2.getTextLength() && offset == document2.getLineStartOffset(document2.getLineNumber(offset));
    }
}

