/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class IndexAccessValidator {
    private final ThreadLocal<ID<?, ?>> ourAlreadyProcessingIndices = new ThreadLocal();

    public void checkAccessingIndexDuringOtherIndexProcessing(@NotNull ID<?, ?> indexKey) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/util/indexing/IndexAccessValidator", "checkAccessingIndexDuringOtherIndexProcessing"));
        }
        ID<?, ?> alreadyProcessingIndex = this.ourAlreadyProcessingIndices.get();
        if (alreadyProcessingIndex != null && alreadyProcessingIndex != indexKey) {
            String message = MessageFormat.format("Accessing ''{0}'' during processing ''{1}''. Nested different indices processing may cause deadlock", indexKey.toString(), alreadyProcessingIndex.toString());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message);
            }
            Logger.getInstance(FileBasedIndexImpl.class).error(message);
        }
    }

    public void startedProcessingActivityForIndex(ID<?, ?> indexId) {
        this.ourAlreadyProcessingIndices.set(indexId);
    }

    public void stoppedProcessingActivityForIndex(ID<?, ?> indexId) {
        this.ourAlreadyProcessingIndices.set(null);
    }
}

