/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SingletonRefGroup
implements RefGroup {
    private final VcsRef myRef;

    public SingletonRefGroup(VcsRef ref) {
        this.myRef = ref;
    }

    public boolean isExpanded() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.myRef.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SingletonRefGroup", "getName"));
        }
        return string;
    }

    @NotNull
    public List<VcsRef> getRefs() {
        List<VcsRef> list = Collections.singletonList(this.myRef);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SingletonRefGroup", "getRefs"));
        }
        return list;
    }

    @NotNull
    public Color getBgColor() {
        Color color = this.myRef.getType().getBackgroundColor();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/SingletonRefGroup", "getBgColor"));
        }
        return color;
    }
}

