/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.util.CatchingConsumer;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageManagementService {
    @Nullable
    public List<String> getAllRepositories() {
        return null;
    }

    public boolean canModifyRepository(String repositoryUrl) {
        return true;
    }

    public void addRepository(String repositoryUrl) {
    }

    public void removeRepository(String repositoryUrl) {
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version1", "com/intellij/webcore/packaging/PackageManagementService", "compareVersions"));
        }
        if (version2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version2", "com/intellij/webcore/packaging/PackageManagementService", "compareVersions"));
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
    }

    public abstract List<RepoPackage> getAllPackages() throws IOException;

    public abstract List<RepoPackage> reloadAllPackages() throws IOException;

    public List<RepoPackage> getAllPackagesCached() {
        return Collections.emptyList();
    }

    public boolean canInstallToUser() {
        return false;
    }

    public String getInstallToUserText() {
        return "";
    }

    public boolean isInstallToUserSelected() {
        return false;
    }

    public void installToUserChanged(boolean newValue) {
    }

    public abstract Collection<InstalledPackage> getInstalledPackages() throws IOException;

    public abstract void installPackage(RepoPackage var1, @Nullable String var2, boolean var3, @Nullable String var4, Listener var5, boolean var6);

    public abstract void uninstallPackages(List<InstalledPackage> var1, Listener var2);

    public abstract void fetchPackageVersions(String var1, CatchingConsumer<List<String>, Exception> var2);

    public abstract void fetchPackageDetails(String var1, CatchingConsumer<String, Exception> var2);

    public static class ErrorDescription {
        @NotNull
        private final String myMessage;
        @Nullable
        private final String myCommand;
        @Nullable
        private final String myOutput;
        @Nullable
        private final String mySolution;

        @Nullable
        public static ErrorDescription fromMessage(@Nullable String message) {
            return message != null ? new ErrorDescription(message, null, null, null) : null;
        }

        public ErrorDescription(@NotNull String message, @Nullable String command, @Nullable String output, @Nullable String solution) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/webcore/packaging/PackageManagementService$ErrorDescription", "<init>"));
            }
            this.myMessage = message;
            this.myCommand = command;
            this.myOutput = output;
            this.mySolution = solution;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/PackageManagementService$ErrorDescription", "getMessage"));
            }
            return string;
        }

        @Nullable
        public String getCommand() {
            return this.myCommand;
        }

        @Nullable
        public String getOutput() {
            return this.myOutput;
        }

        @Nullable
        public String getSolution() {
            return this.mySolution;
        }
    }

    public static interface Listener {
        public void operationStarted(String var1);

        public void operationFinished(String var1, @Nullable ErrorDescription var2);
    }
}

