/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<String, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "<init>"));
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location);
        } else {
            this.groupedMessages.put((Object)location.getPath(), (Object)new Message(severity, message, location));
        }
    }

    @Override
    public boolean hasErrors() {
        for (Map.Entry entry : this.groupedMessages.entries()) {
            if (!((Message)entry.getValue()).severity.isError()) continue;
            return true;
        }
        return false;
    }

    public void flush() {
        boolean hasErrors = this.hasErrors();
        for (String path : this.sortedKeys()) {
            for (Message message : this.groupedMessages.get((Object)path)) {
                if (hasErrors && !message.severity.isError()) continue;
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    @NotNull
    private Collection<String> sortedKeys() {
        ArrayList<String> sortedKeys = new ArrayList<String>(this.groupedMessages.keySet());
        Collections.sort(sortedKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        ArrayList<String> arrayList = sortedKeys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "sortedKeys"));
        }
        return arrayList;
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            this.severity = severity;
            this.message = message;
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message1 = (Message)o;
            if (!this.location.equals(message1.location)) {
                return false;
            }
            if (!this.message.equals(message1.message)) {
                return false;
            }
            return this.severity == message1.severity;
        }

        public int hashCode() {
            int result = this.severity.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + this.location.hashCode();
            return result;
        }
    }
}

