/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class UnaryExpr
extends Expr {
    final String mOp;

    UnaryExpr(String op, Expr expr) {
        super(expr);
        this.mOp = op;
    }

    @Override
    public String getInvertibleError() {
        return this.getExpr().getInvertibleError();
    }

    @Override
    protected String computeUniqueKey() {
        return this.addTwoWay(UnaryExpr.join(this.getOpStr(), this.getExpr().getUniqueKey()));
    }

    @Override
    public KCode toInverseCode(KCode value) {
        return this.getExpr().toInverseCode(new KCode().app(this.mOp, value));
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode().app(this.getOp(), this.getExpr().toCode(expand));
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return this.getExpr().getResolvedType();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    private String getOpStr() {
        switch (this.mOp.charAt(0)) {
            case '~': {
                return "bitNot";
            }
            case '!': {
                return "logicalNot";
            }
            case '-': {
                return "unaryMinus";
            }
            case '+': {
                return "unaryPlus";
            }
        }
        return this.mOp;
    }

    public String getOp() {
        return this.mOp;
    }

    public Expr getExpr() {
        return this.getChildren().get(0);
    }
}

