/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenPathReferenceConverter
extends PathReferenceConverter {
    private final Condition<PsiFileSystemItem> myCondition;

    public MavenPathReferenceConverter() {
        this((Condition<PsiFileSystemItem>)Conditions.alwaysTrue());
    }

    public MavenPathReferenceConverter(@NotNull Condition<PsiFileSystemItem> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter", "<init>"));
        }
        this.myCondition = condition;
    }

    public static PsiReference[] createReferences(DomElement genericDomValue, PsiElement element, @NotNull Condition<PsiFileSystemItem> fileFilter) {
        if (fileFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFilter", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter", "createReferences"));
        }
        return MavenPathReferenceConverter.createReferences(genericDomValue, element, fileFilter, false);
    }

    public static PsiReference[] createReferences(final DomElement genericDomValue, PsiElement element, final @NotNull Condition<PsiFileSystemItem> fileFilter, boolean isAbsolutePath) {
        if (fileFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFilter", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter", "createReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        String text = range.substring(element.getText());
        FileReferenceSet set = new FileReferenceSet(text, element, range.getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, false){
            private MavenDomProjectModel model;

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return fileFilter;
            }

            protected boolean isSoft() {
                return true;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new FileReference(this, range, index, text){

                    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
                        String resolvedText;
                        DomElement rootElement;
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter$1$1", "innerResolveInContext"));
                        }
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter$1$1", "innerResolveInContext"));
                        }
                        if (model == null && (rootElement = DomUtil.getFileElement((DomElement)genericDomValue).getRootElement()) instanceof MavenDomProjectModel) {
                            model = (MavenDomProjectModel)rootElement;
                        }
                        String string = resolvedText = model == null ? text : MavenPropertyResolver.resolve(text, model);
                        if (resolvedText.equals(text)) {
                            if (this.getIndex() == 0 && resolvedText.length() == 2 && resolvedText.charAt(1) == ':') {
                                PsiDirectory psiDirectory;
                                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(resolvedText + '/');
                                if (file != null && (psiDirectory = context.getManager().findDirectory(file)) != null) {
                                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiDirectory));
                                }
                            } else {
                                super.innerResolveInContext(resolvedText, context, result, caseSensitive);
                            }
                        } else {
                            VirtualFile contextFile = context.getVirtualFile();
                            if (contextFile == null) {
                                return;
                            }
                            VirtualFile file = null;
                            if (this.getIndex() == 0) {
                                file = LocalFileSystem.getInstance().findFileByPath(resolvedText);
                            }
                            if (file == null) {
                                file = LocalFileSystem.getInstance().findFileByPath(contextFile.getPath() + '/' + resolvedText);
                            }
                            if (file != null) {
                                PsiDirectory res;
                                Object object = res = file.isDirectory() ? context.getManager().findDirectory(file) : context.getManager().findFile(file);
                                if (res != null) {
                                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)res));
                                }
                            }
                        }
                    }
                };
            }
        };
        if (isAbsolutePath) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return (Collection)FileReferenceSet.ABSOLUTE_TOP_LEVEL.fun(file);
                }
                virtualFile = VfsUtil.getRootFile((VirtualFile)virtualFile);
                PsiDirectory root = file.getManager().findDirectory(virtualFile);
                if (root == null) {
                    return (Collection)FileReferenceSet.ABSOLUTE_TOP_LEVEL.fun(file);
                }
                return Collections.singletonList(root);
            });
        }
        return set.getAllReferences();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = MavenPathReferenceConverter.createReferences((DomElement)genericDomValue, element, this.myCondition);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter", "createReferences"));
        }
        throw new UnsupportedOperationException();
    }
}

