/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.plugins.api.MavenParamReferenceProvider;
import org.jetbrains.idea.maven.plugins.api.MavenSoftAwareReferenceProvider;

public class MavenFixedValueReferenceProvider
implements MavenParamReferenceProvider,
MavenSoftAwareReferenceProvider {
    private final String[] myValues;
    private boolean mySoft = false;

    public MavenFixedValueReferenceProvider(String[] values) {
        this.myValues = values;
    }

    @Override
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull MavenDomConfiguration domCfg, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/plugins/api/MavenFixedValueReferenceProvider", "getReferencesByElement"));
        }
        if (domCfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domCfg", "org/jetbrains/idea/maven/plugins/api/MavenFixedValueReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/plugins/api/MavenFixedValueReferenceProvider", "getReferencesByElement"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        String text = range.substring(element.getText());
        Matcher matcher = MavenPropertyResolver.PATTERN.matcher(text);
        if (matcher.find()) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new PsiReferenceBase<PsiElement>(element, this.mySoft){

            @Nullable
            public PsiElement resolve() {
                if (this.mySoft) {
                    return null;
                }
                if (Arrays.asList(MavenFixedValueReferenceProvider.this.myValues).contains(this.getValue())) {
                    return this.getElement();
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = MavenFixedValueReferenceProvider.this.myValues;
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/plugins/api/MavenFixedValueReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }
        }};
    }

    @Override
    public void setSoft(boolean soft) {
        this.mySoft = soft;
    }
}

