/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQFoldCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQFoldCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQFoldCommand", "<init>"));
        }
        this.myRepository = repository;
    }

    public void executeInCurrentThread(@NotNull List<String> patchNames) {
        if (patchNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchNames", "org/zmlx/hg4idea/command/mq/HgQFoldCommand", "executeInCurrentThread"));
        }
        Project project = this.myRepository.getProject();
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(this.myRepository.getRoot(), "qfold", patchNames);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "QFold command failed", "Could not fold patches into the current patch");
        }
        this.myRepository.update();
    }
}

