/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.extract.PrimitiveTypes;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class TypeCompatibilityModelProjectionSupport<M>
implements ModelProjection {
    private final ModelType<M> type;

    public TypeCompatibilityModelProjectionSupport(ModelType<M> type) {
        this.type = type;
    }

    protected ModelType<M> getType() {
        return this.type;
    }

    @Override
    public <T> boolean canBeViewedAs(ModelType<T> targetType) {
        return this.canBeAssignedTo(targetType);
    }

    private <T> boolean canBeAssignedTo(ModelType<T> targetType) {
        return targetType.isAssignableFrom(this.type) || targetType == ModelType.UNTYPED && PrimitiveTypes.isPrimitiveType(this.type);
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor) {
        if (this.canBeViewedAs(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(modelNode, ruleDescriptor, true));
        }
        return null;
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor) {
        if (this.canBeViewedAs(type)) {
            return (ModelView)Cast.uncheckedCast(this.toView(modelNode, ruleDescriptor, false));
        }
        return null;
    }

    protected abstract ModelView<M> toView(MutableModelNode var1, ModelRuleDescriptor var2, boolean var3);

    @Override
    public Iterable<String> getTypeDescriptions(MutableModelNode node) {
        return Collections.singleton(TypeCompatibilityModelProjectionSupport.description(this.type));
    }

    protected String toStringValueDescription(Object instance) {
        String valueDescription = instance.toString();
        if (valueDescription != null) {
            return valueDescription;
        }
        return this.type.toString() + "#toString() returned null";
    }

    public static String description(ModelType<?> type) {
        if (type.getRawClass().getSuperclass() == null && type.getRawClass().getInterfaces().length == 0) {
            return type.toString();
        }
        return type.toString() + " (or assignment compatible type thereof)";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityModelProjectionSupport that = (TypeCompatibilityModelProjectionSupport)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.type + "]";
    }
}

