/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testng.IDEATestNGRemoteListener;
import org.testng.IDEATestNGSuiteListener;
import org.testng.IDEATestNGTestListener;
import org.testng.TestNG;
import org.testng.collections.Lists;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEARemoteTestNG
extends TestNG {
    private final String myParam;

    public IDEARemoteTestNG(String param) {
        this.myParam = param;
    }

    private static void calculateAllSuites(List<XmlSuite> suites, List<XmlSuite> outSuites) {
        for (XmlSuite s : suites) {
            outSuites.add(s);
            IDEARemoteTestNG.calculateAllSuites(s.getChildSuites(), outSuites);
        }
    }

    public void run() {
        try {
            this.initializeSuitesAndJarFile();
            List suites = Lists.newArrayList();
            IDEARemoteTestNG.calculateAllSuites(this.m_suites, suites);
            if (suites.size() > 0) {
                for (XmlSuite suite : suites) {
                    List tests = suite.getTests();
                    for (XmlTest test : tests) {
                        try {
                            if (this.myParam == null) continue;
                            for (XmlClass aClass : test.getXmlClasses()) {
                                ArrayList<XmlInclude> includes = new ArrayList<XmlInclude>();
                                for (XmlInclude include : aClass.getIncludedMethods()) {
                                    includes.add(new XmlInclude(include.getName(), Collections.singletonList(Integer.parseInt(this.myParam)), 0));
                                }
                                aClass.setIncludedMethods(includes);
                            }
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Invocation number: expected integer but found: " + this.myParam);
                        }
                    }
                }
                this.attachListeners(new IDEATestNGRemoteListener());
                super.run();
                System.exit(0);
            } else {
                System.out.println("##teamcity[enteredTheMatrix]");
                System.err.println("Nothing found to run");
            }
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
        }
    }

    private void attachListeners(IDEATestNGRemoteListener listener) {
        this.addListener(new IDEATestNGSuiteListener(listener));
        this.addListener(new IDEATestNGTestListener(listener));
        try {
            Class<?> configClass = Class.forName("org.testng.IDEATestNGConfigurationListener");
            Object configurationListener = configClass.getConstructor(IDEATestNGRemoteListener.class).newInstance(listener);
            this.addListener(configurationListener);
            Class<?> invokeClass = Class.forName("org.testng.IDEATestNGInvokedMethodListener");
            Object invokedMethodListener = invokeClass.getConstructor(IDEATestNGRemoteListener.class).newInstance(listener);
            this.addListener(invokedMethodListener);
            configClass.getMethod("setIgnoreStarted", new Class[0]).invoke(configurationListener, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

