/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.KtLightElement;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a$\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002\u001a,\u0010\r\u001a\u0004\u0018\u00010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\t\u00a8\u0006\u0010"}, d2={"getModuleInfoByVirtualFile", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDecompiledFile", "", "getModuleInfo", "Lcom/intellij/psi/PsiElement;", "onFailure", "Lkotlin/Function1;", "", "getModuleInfoForLightElement", "Lorg/jetbrains/kotlin/asJava/KtLightElement;", "getNullableModuleInfo", "idea-analysis"})
public final class GetModuleInfoKt {
    @NotNull
    public static final IdeaModuleInfo getModuleInfo(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IdeaModuleInfo $receiver$iv = GetModuleInfoKt.getModuleInfo($receiver, (Function1<? super String, ? extends IdeaModuleInfo>)((Function1)getModuleInfo.1.INSTANCE));
        IdeaModuleInfo ideaModuleInfo = $receiver$iv;
        if (ideaModuleInfo == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "Defaulting to NotUnderContentRootModuleInfo so null is not possible";
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        return ideaModuleInfo;
    }

    @Nullable
    public static final IdeaModuleInfo getNullableModuleInfo(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return GetModuleInfoKt.getModuleInfo($receiver, (Function1<? super String, ? extends IdeaModuleInfo>)((Function1)getNullableModuleInfo.1.INSTANCE));
    }

    private static final IdeaModuleInfo getModuleInfo(@NotNull PsiElement $receiver, Function1<? super String, ? extends IdeaModuleInfo> onFailure) {
        Object explicitModuleInfo;
        String doNotAnalyze;
        PsiElement context;
        KtFile containingJetFile;
        ModuleInfo moduleInfo = KtPsiFactoryKt.getModuleInfo($receiver.getContainingFile());
        if (!(moduleInfo instanceof IdeaModuleInfo)) {
            moduleInfo = null;
        }
        IdeaModuleInfo ideaModuleInfo = (IdeaModuleInfo)moduleInfo;
        if (ideaModuleInfo != null) {
            IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
            IdeaModuleInfo it = ideaModuleInfo2;
            return it;
        }
        if ($receiver instanceof KtLightElement) {
            return GetModuleInfoKt.getModuleInfoForLightElement((KtLightElement)$receiver, onFailure);
        }
        PsiElement psiElement = $receiver;
        if (!(psiElement instanceof KtElement)) {
            psiElement = null;
        }
        KtElement ktElement = (KtElement)psiElement;
        Object object = ktElement != null ? ktElement.getContainingFile() : null;
        if (!(object instanceof KtFile)) {
            object = null;
        }
        KtFile ktFile = containingJetFile = (KtFile)object;
        Object object2 = context = ktFile != null ? KtPsiFactoryKt.getAnalysisContext(ktFile) : null;
        if (context != null) {
            return GetModuleInfoKt.getModuleInfo(context);
        }
        KtFile ktFile2 = containingJetFile;
        String string = doNotAnalyze = ktFile2 != null ? KtPsiFactoryKt.getDoNotAnalyze(ktFile2) : null;
        if (doNotAnalyze != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Should not analyze element: ").append($receiver.getText()).append(" in file ");
            Object object3 = containingJetFile;
            if (object3 == null || (object3 = ((KtFile)object3).getName()) == null) {
                object3 = " <no file>";
            }
            return (IdeaModuleInfo)onFailure.invoke((Object)stringBuilder.append((String)object3).append("\n").append(doNotAnalyze).toString());
        }
        Object object4 = containingJetFile;
        if (object4 == null || (object4 = KtPsiFactoryKt.getModuleInfo((PsiFile)object4)) == null) {
            KtFile ktFile3 = containingJetFile;
            Object object5 = ktFile3 != null ? ktFile3.getOriginalFile() : null;
            if (!(object5 instanceof KtFile)) {
                object5 = null;
            }
            KtFile ktFile4 = (KtFile)object5;
            object4 = explicitModuleInfo = ktFile4 != null ? KtPsiFactoryKt.getModuleInfo((PsiFile)ktFile4) : null;
        }
        if (explicitModuleInfo instanceof IdeaModuleInfo) {
            return (IdeaModuleInfo)explicitModuleInfo;
        }
        if (containingJetFile instanceof KtCodeFragment) {
            Object object6 = containingJetFile.getContext();
            if (object6 == null || (object6 = GetModuleInfoKt.getModuleInfo(object6)) == null) {
                object6 = (IdeaModuleInfo)onFailure.invoke((Object)("Analyzing code fragment of type " + ((KtCodeFragment)containingJetFile).getClass() + " with no context element" + "\n" + "Text:" + "\n" + containingJetFile.getText()));
            }
            return object6;
        }
        PsiFile psiFile = $receiver.getContainingFile();
        if (psiFile == null) {
            return (IdeaModuleInfo)onFailure.invoke((Object)("Analyzing element of type " + $receiver.getClass() + " with no containing file" + "\n" + "Text:" + "\n" + $receiver.getText()));
        }
        PsiFile containingFile = psiFile;
        VirtualFile virtualFile2 = containingFile.getOriginalFile().getVirtualFile();
        if (virtualFile2 == null) {
            return (IdeaModuleInfo)onFailure.invoke((Object)("Analyzing element of type " + $receiver.getClass() + " in non-physical file " + containingFile + " of type " + containingFile.getClass() + "\n" + "Text:" + "\n" + $receiver.getText()));
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        PsiFile psiFile2 = containingFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile5 = (KtFile)psiFile2;
        return GetModuleInfoKt.getModuleInfoByVirtualFile(project, virtualFile3, ktFile5 != null ? ktFile5.isCompiled() : false);
    }

    private static final IdeaModuleInfo getModuleInfoByVirtualFile(Project project, VirtualFile virtualFile2, boolean isDecompiledFile) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(virtualFile2);
        if (module != null) {
            Function0<Unit> warnIfDecompiled$ = new Function0<Unit>(isDecompiledFile, virtualFile2, module){
                final /* synthetic */ boolean $isDecompiledFile;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Module $module;

                public final void invoke() {
                    if (this.$isDecompiledFile) {
                        KotlinCacheServiceImplKt.getLOG().warn("Decompiled file for " + this.$virtualFile.getCanonicalPath() + " is in content of " + this.$module);
                    }
                }
                {
                    this.$isDecompiledFile = bl;
                    this.$virtualFile = virtualFile2;
                    this.$module = module;
                    super(0);
                }
            };
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (moduleFileIndex.isInTestSourceContent(virtualFile2)) {
                warnIfDecompiled$.invoke();
                return IdeaModuleInfosKt.testSourceInfo(module);
            }
            if (moduleFileIndex.isInSourceContent(virtualFile2)) {
                warnIfDecompiled$.invoke();
                return IdeaModuleInfosKt.productionSourceInfo(module);
            }
        }
        List orderEntries = projectFileIndex.getOrderEntriesForFile(virtualFile2);
        for (OrderEntry orderEntry : orderEntries) {
            if (!orderEntry.isValid()) continue;
            OrderEntry orderEntry2 = orderEntry;
            if (orderEntry2 instanceof LibraryOrderEntry) {
                Library library;
                if (((LibraryOrderEntry)orderEntry).getLibrary() == null) {
                    continue;
                }
                if (ProjectRootsUtil.isLibraryClassFile(project, virtualFile2) && !isDecompiledFile) {
                    Library library2 = library;
                    Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
                    return new LibraryInfo(project, library2);
                }
                if (!ProjectRootsUtil.isLibraryFile(project, virtualFile2) && !isDecompiledFile) continue;
                Library library3 = library;
                Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
                return new LibrarySourceInfo(project, library3);
            }
            if (!(orderEntry2 instanceof JdkOrderEntry)) continue;
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                continue;
            }
            Sdk sdk2 = sdk;
            return new SdkInfo(project, sdk2);
        }
        return NotUnderContentRootModuleInfo.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final IdeaModuleInfo getModuleInfoForLightElement(@NotNull KtLightElement<?, ?> $receiver, Function1<? super String, ? extends IdeaModuleInfo> onFailure) {
        NavigatablePsiElement navigatablePsiElement;
        void strict$iv;
        VirtualFile $receiver$iv;
        PsiElement psiElement = (PsiElement)$receiver;
        boolean bl = false;
        KtLightClassForDecompiledDeclaration decompiledClass = (KtLightClassForDecompiledDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLightClassForDecompiledDeclaration.class, (boolean)strict$iv);
        if (decompiledClass != null) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            $receiver$iv = $receiver.getContainingFile().getVirtualFile();
            Project project2 = project;
            VirtualFile virtualFile2 = $receiver$iv;
            if (virtualFile2 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "Decompiled class should be build from physical file";
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            VirtualFile virtualFile3 = virtualFile2;
            return GetModuleInfoKt.getModuleInfoByVirtualFile(project2, virtualFile3, false);
        }
        Object obj = $receiver.getKotlinOrigin();
        if (obj != null) {
            navigatablePsiElement = (NavigatablePsiElement)obj;
        } else {
            PsiFile psiFile;
            KtLightElement<?, ?> ktLightElement = $receiver;
            if (ktLightElement instanceof FakeLightClassForFileOfPackage) {
                psiFile = $receiver.getContainingFile();
                if (psiFile == null) {
                    Intrinsics.throwNpe();
                }
            } else if (ktLightElement instanceof KtLightClassForFacade) {
                psiFile = (PsiFile)CollectionsKt.first((Iterable)((KtLightClassForFacade)$receiver).getFiles());
            } else {
                return (IdeaModuleInfo)onFailure.invoke((Object)("Light element without origin is referenced by resolve:" + "\n" + $receiver + "\n" + $receiver.getClsDelegate().getText()));
            }
            navigatablePsiElement = (NavigatablePsiElement)psiFile;
        }
        NavigatablePsiElement element2 = navigatablePsiElement;
        return GetModuleInfoKt.getModuleInfo((PsiElement)element2);
    }
}

