/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.configuration.RuntimeLibraryFiles;
import org.jetbrains.kotlin.idea.framework.ui.CreateLibraryDialogWithModules;
import org.jetbrains.kotlin.idea.framework.ui.FileUIUtils;

public abstract class KotlinWithLibraryConfigurator
implements KotlinProjectConfigurator {
    public static final String DEFAULT_LIBRARY_DIR = "lib";

    @NotNull
    protected abstract String getLibraryName();

    @NotNull
    protected abstract String getMessageForOverrideDialog();

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    protected abstract String getLibraryCaption();

    @NotNull
    public abstract RuntimeLibraryFiles getExistingJarFiles();

    @Nullable
    protected abstract String getOldSourceRootUrl(@NotNull Library var1);

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "isApplicable"));
        }
        return !KotlinPluginUtil.isAndroidGradleModule(module) && !KotlinPluginUtil.isMavenModule(module) && !KotlinPluginUtil.isGradleModule(module);
    }

    @Override
    public void configure(@NotNull Project project, Collection<Module> excludeModules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configure"));
        }
        String defaultPathToJar = this.getDefaultPathToJarFile(project);
        boolean showPathToJarPanel = this.needToChooseJarPath(project);
        List<Module> nonConfiguredModules = !ApplicationManager.getApplication().isUnitTestMode() ? ConfigureKotlinInProjectUtilsKt.getNonConfiguredModules(project, this) : Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        nonConfiguredModules.removeAll(excludeModules);
        List<Module> modulesToConfigure = nonConfiguredModules;
        String copyLibraryIntoPath = null;
        if (nonConfiguredModules.size() > 1 || showPathToJarPanel) {
            CreateLibraryDialogWithModules dialog2 = new CreateLibraryDialogWithModules(project, this, defaultPathToJar, showPathToJarPanel, this.getDialogTitle(), this.getLibraryCaption(), excludeModules);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dialog2.show();
                if (!dialog2.isOK()) {
                    return;
                }
            }
            modulesToConfigure = dialog2.getModulesToConfigure();
            copyLibraryIntoPath = dialog2.getCopyIntoPath();
        }
        List<Module> finalModulesToConfigure = modulesToConfigure;
        String finalCopyLibraryIntoPath = copyLibraryIntoPath;
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        for (Module module : finalModulesToConfigure) {
            this.configureModuleWithLibrary(module, defaultPathToJar, finalCopyLibraryIntoPath, collector2);
        }
        collector2.showNotification();
    }

    public void configureSilently(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureSilently"));
        }
        String defaultPathToJar = this.getDefaultPathToJarFile(project);
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.configureModuleWithLibrary(module, defaultPathToJar, null, collector2);
        }
    }

    protected void configureModuleWithLibrary(@NotNull Module module, @NotNull String defaultPath, @Nullable String pathFromDialog, @NotNull NotificationMessageCollector collector2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibrary"));
        }
        if (defaultPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPath", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibrary"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibrary"));
        }
        Project project = module.getProject();
        RuntimeLibraryFiles files = this.getExistingJarFiles();
        LibraryState libraryState = this.getLibraryState(project);
        String dirToCopyJar = this.getPathToCopyFileTo(project, OrderRootType.CLASSES, defaultPath, pathFromDialog);
        FileState runtimeState = this.getJarState(project, files.getRuntimeDestination(dirToCopyJar), OrderRootType.CLASSES, pathFromDialog == null);
        this.configureModuleWithLibraryClasses(module, libraryState, runtimeState, dirToCopyJar, collector2);
        Library library = this.getKotlinLibrary(project);
        assert (library != null) : "Kotlin library should exists when adding sources root";
        String dirToCopySourcesJar = this.getPathToCopyFileTo(project, OrderRootType.SOURCES, defaultPath, pathFromDialog);
        FileState sourcesState = this.getJarState(project, files.getRuntimeSourcesDestination(dirToCopySourcesJar), OrderRootType.SOURCES, pathFromDialog == null);
        this.configureModuleWithLibrarySources(library, sourcesState, dirToCopySourcesJar, collector2);
    }

    protected void configureModuleWithLibraryClasses(@NotNull Module module, @NotNull LibraryState libraryState, @NotNull FileState jarState, @NotNull String dirToCopyJarTo, @NotNull NotificationMessageCollector collector2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibraryClasses"));
        }
        if (libraryState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryState", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibraryClasses"));
        }
        if (jarState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarState", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibraryClasses"));
        }
        if (dirToCopyJarTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirToCopyJarTo", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibraryClasses"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibraryClasses"));
        }
        Project project = module.getProject();
        RuntimeLibraryFiles files = this.getExistingJarFiles();
        File runtimeJar = files.getRuntimeJar();
        File reflectJar = files.getReflectJar();
        block0 : switch (libraryState) {
            case LIBRARY: {
                switch (jarState) {
                    case EXISTS: {
                        break;
                    }
                    case COPY: {
                        this.copyFileToDir(runtimeJar, dirToCopyJarTo, collector2);
                        if (reflectJar == null) break;
                        this.copyFileToDir(reflectJar, dirToCopyJarTo, collector2);
                        break;
                    }
                    case DO_NOT_COPY: {
                        throw new IllegalStateException("Kotlin library exists, so path to copy should be hidden in configuration dialog and jar should be copied using path in library table");
                    }
                }
                break;
            }
            case NON_CONFIGURED_LIBRARY: {
                switch (jarState) {
                    case EXISTS: {
                        this.addJarsToExistingLibrary(project, files.getRuntimeDestination(dirToCopyJarTo), files.getReflectDestination(dirToCopyJarTo), collector2);
                        break;
                    }
                    case COPY: {
                        File copiedRuntimeJar = this.copyFileToDir(runtimeJar, dirToCopyJarTo, collector2);
                        File copiedReflectJar = this.copyFileToDir(reflectJar, dirToCopyJarTo, collector2);
                        this.addJarsToExistingLibrary(project, copiedRuntimeJar, copiedReflectJar, collector2);
                        break;
                    }
                    case DO_NOT_COPY: {
                        this.addJarsToExistingLibrary(project, runtimeJar, reflectJar, collector2);
                    }
                }
                break;
            }
            case NEW_LIBRARY: {
                switch (jarState) {
                    case EXISTS: {
                        this.addJarsToNewLibrary(project, files.getRuntimeDestination(dirToCopyJarTo), files.getReflectDestination(dirToCopyJarTo), collector2);
                        break block0;
                    }
                    case COPY: {
                        File copiedRuntimeJar = this.copyFileToDir(runtimeJar, dirToCopyJarTo, collector2);
                        File copiedReflectJar = this.copyFileToDir(reflectJar, dirToCopyJarTo, collector2);
                        this.addJarsToNewLibrary(project, copiedRuntimeJar, copiedReflectJar, collector2);
                        break block0;
                    }
                    case DO_NOT_COPY: {
                        this.addJarsToNewLibrary(project, runtimeJar, reflectJar, collector2);
                    }
                }
            }
        }
        this.addLibraryToModuleIfNeeded(module, collector2);
    }

    protected void configureModuleWithLibrarySources(@NotNull Library library, @NotNull FileState jarState, @Nullable String dirToCopyJarTo, @NotNull NotificationMessageCollector collector2) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibrarySources"));
        }
        if (jarState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarState", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibrarySources"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "configureModuleWithLibrarySources"));
        }
        RuntimeLibraryFiles files = this.getExistingJarFiles();
        File runtimeSourcesJar = files.getRuntimeSourcesJar();
        switch (jarState) {
            case EXISTS: {
                if (dirToCopyJarTo == null) break;
                KotlinWithLibraryConfigurator.addSourcesToLibraryIfNeeded(library, files.getRuntimeSourcesDestination(dirToCopyJarTo), collector2);
                break;
            }
            case COPY: {
                assert (dirToCopyJarTo != null) : "Path to copy should be non-null";
                File file2 = this.copyFileToDir(runtimeSourcesJar, dirToCopyJarTo, collector2);
                KotlinWithLibraryConfigurator.addSourcesToLibraryIfNeeded(library, file2, collector2);
                break;
            }
            case DO_NOT_COPY: {
                KotlinWithLibraryConfigurator.addSourcesToLibraryIfNeeded(library, runtimeSourcesJar, collector2);
            }
        }
    }

    @Nullable
    public Library getKotlinLibrary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getKotlinLibrary"));
        }
        LibrariesContainer librariesContainer = LibrariesContainerFactory.createContainer((Project)project);
        for (Library library : librariesContainer.getLibraries(LibrariesContainer.LibraryLevel.PROJECT)) {
            if (!this.isKotlinLibrary(project, library)) continue;
            return library;
        }
        for (Library library : librariesContainer.getLibraries(LibrariesContainer.LibraryLevel.GLOBAL)) {
            if (!this.isKotlinLibrary(project, library)) continue;
            return library;
        }
        return null;
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public File copyFileToDir(@Nullable File file2, @NotNull String toDir, @NotNull NotificationMessageCollector collector2) {
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "copyFileToDir"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "copyFileToDir"));
        }
        if (file2 == null) {
            return null;
        }
        File copy = FileUIUtils.copyWithOverwriteDialog(this.getMessageForOverrideDialog(), toDir, file2);
        if (copy != null) {
            collector2.addMessage(file2.getName() + " was copied to " + toDir);
        }
        return copy;
    }

    @Nullable
    protected String getPathFromLibrary(@NotNull Project project, @NotNull OrderRootType type2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathFromLibrary"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathFromLibrary"));
        }
        return KotlinWithLibraryConfigurator.getPathFromLibrary(this.getKotlinLibrary(project), type2);
    }

    @Nullable
    protected static String getPathFromLibrary(@Nullable Library library, @NotNull OrderRootType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathFromLibrary"));
        }
        if (library == null) {
            return null;
        }
        String[] libraryFiles = library.getUrls(type2);
        if (libraryFiles.length < 1) {
            return null;
        }
        String pathToJarInLib = VfsUtilCore.urlToPath((String)libraryFiles[0]);
        String parentDir = VfsUtil.getParentDir((String)VfsUtil.getParentDir((String)pathToJarInLib));
        if (parentDir == null) {
            return null;
        }
        File parentDirFile = new File(parentDir);
        if (!parentDirFile.exists() && !parentDirFile.mkdirs()) {
            return null;
        }
        return parentDir;
    }

    protected static boolean addSourcesToLibraryIfNeeded(@NotNull Library library, @NotNull File file2, @NotNull NotificationMessageCollector collector2) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addSourcesToLibraryIfNeeded"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addSourcesToLibraryIfNeeded"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addSourcesToLibraryIfNeeded"));
        }
        String[] librarySourceRoots = library.getUrls(OrderRootType.SOURCES);
        String librarySourceRoot = VfsUtil.getUrlForLibraryRoot((File)file2);
        for (String sourceRoot : librarySourceRoots) {
            if (!sourceRoot.equals(librarySourceRoot)) continue;
            return false;
        }
        final Library.ModifiableModel model = library.getModifiableModel();
        model.addRoot(librarySourceRoot, OrderRootType.SOURCES);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                model.commit();
            }
        });
        collector2.addMessage("Source root '" + librarySourceRoot + "' was added to " + library.getName() + " library");
        return true;
    }

    private void addLibraryToModuleIfNeeded(Module module, NotificationMessageCollector collector2) {
        DependencyScope expectedDependencyScope = KotlinWithLibraryConfigurator.getDependencyScope(module);
        Library kotlinLibrary = this.getKotlinLibrary(module);
        if (kotlinLibrary == null) {
            Library library = this.getKotlinLibrary(module.getProject());
            assert (library != null) : "Kotlin project library should exists";
            ModuleRootModificationUtil.addDependency((Module)module, (Library)library, (DependencyScope)expectedDependencyScope, (boolean)false);
            collector2.addMessage(library.getName() + " library was added to module " + module.getName());
        } else {
            DependencyScope libraryDependencyScope;
            LibraryOrderEntry libraryEntry = KotlinWithLibraryConfigurator.findLibraryOrderEntry(ModuleRootManager.getInstance((Module)module).getOrderEntries(), kotlinLibrary);
            if (libraryEntry != null && !expectedDependencyScope.equals((Object)(libraryDependencyScope = libraryEntry.getScope()))) {
                libraryEntry.setScope(expectedDependencyScope);
                collector2.addMessage(kotlinLibrary.getName() + " library scope has changed from " + libraryDependencyScope + " to " + expectedDependencyScope + " for module " + module.getName());
            }
        }
    }

    @Nullable
    private static LibraryOrderEntry findLibraryOrderEntry(@NotNull OrderEntry[] orderEntries, @NotNull Library library) {
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntries", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "findLibraryOrderEntry"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "findLibraryOrderEntry"));
        }
        for (OrderEntry orderEntry : orderEntries) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @NotNull
    private static DependencyScope getDependencyScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getDependencyScope"));
        }
        if (ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getDependencyScope"));
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getDependencyScope"));
        }
        return dependencyScope;
    }

    private void addJarsToExistingLibrary(@NotNull Project project, @NotNull File runtimeJar, @Nullable File reflectJar, @NotNull NotificationMessageCollector collector2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addJarsToExistingLibrary"));
        }
        if (runtimeJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeJar", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addJarsToExistingLibrary"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addJarsToExistingLibrary"));
        }
        Library library = this.getKotlinLibrary(project);
        assert (library != null) : "Kotlin library should present, instead createNewLibrary should be invoked";
        final Library.ModifiableModel model = library.getModifiableModel();
        model.addRoot(VfsUtil.getUrlForLibraryRoot((File)runtimeJar), OrderRootType.CLASSES);
        if (reflectJar != null) {
            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)reflectJar), OrderRootType.CLASSES);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                model.commit();
            }
        });
        collector2.addMessage(library.getName() + " library was configured");
    }

    private void addJarsToNewLibrary(@NotNull Project project, final @NotNull File runtimeJar, final @Nullable File reflectJar, @NotNull NotificationMessageCollector collector2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addJarsToNewLibrary"));
        }
        if (runtimeJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeJar", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addJarsToNewLibrary"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "addJarsToNewLibrary"));
        }
        final LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        final Ref library = new Ref();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                library.set((Object)table.createLibrary(KotlinWithLibraryConfigurator.this.getLibraryName()));
                Library.ModifiableModel model = ((Library)library.get()).getModifiableModel();
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)runtimeJar), OrderRootType.CLASSES);
                if (reflectJar != null) {
                    model.addRoot(VfsUtil.getUrlForLibraryRoot((File)reflectJar), OrderRootType.CLASSES);
                }
                model.commit();
            }
        });
        collector2.addMessage(((Library)library.get()).getName() + " library was created");
    }

    private boolean isProjectLibraryWithoutPathsPresent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "isProjectLibraryWithoutPathsPresent"));
        }
        Library library = this.getKotlinLibrary(project);
        return library != null && library.getUrls(OrderRootType.CLASSES).length == 0;
    }

    private boolean isProjectLibraryPresent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "isProjectLibraryPresent"));
        }
        Library library = this.getKotlinLibrary(project);
        return library != null && library.getUrls(OrderRootType.CLASSES).length > 0;
    }

    @Nullable
    private Library getKotlinLibrary(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getKotlinLibrary"));
        }
        final Ref result2 = Ref.create(null);
        OrderEnumerator.orderEntries((Module)module).forEachLibrary((Processor)new Processor<Library>(){

            public boolean process(Library library) {
                if (KotlinWithLibraryConfigurator.this.isKotlinLibrary(module.getProject(), library)) {
                    result2.set((Object)library);
                    return false;
                }
                return true;
            }
        });
        return (Library)result2.get();
    }

    protected boolean isKotlinLibrary(@NotNull Project project, @NotNull Library library) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "isKotlinLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "isKotlinLibrary"));
        }
        if (this.getLibraryName().equals(library.getName())) {
            return true;
        }
        String fileName = this.getExistingJarFiles().getRuntimeJar().getName();
        for (VirtualFile root : library.getFiles(OrderRootType.CLASSES)) {
            if (!root.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    protected boolean needToChooseJarPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "needToChooseJarPath"));
        }
        String defaultPath = this.getDefaultPathToJarFile(project);
        return !this.isProjectLibraryPresent(project) && !this.getExistingJarFiles().getRuntimeDestination(defaultPath).exists();
    }

    protected String getDefaultPathToJarFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getDefaultPathToJarFile"));
        }
        return FileUIUtils.createRelativePath(project, project.getBaseDir(), DEFAULT_LIBRARY_DIR);
    }

    protected void showError(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "showError"));
        }
        Messages.showErrorDialog((String)message2, (String)this.getMessageForOverrideDialog());
    }

    @NotNull
    protected LibraryState getLibraryState(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getLibraryState"));
        }
        if (this.isProjectLibraryPresent(project)) {
            LibraryState libraryState = LibraryState.LIBRARY;
            if (libraryState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getLibraryState"));
            }
            return libraryState;
        }
        if (this.isProjectLibraryWithoutPathsPresent(project)) {
            LibraryState libraryState = LibraryState.NON_CONFIGURED_LIBRARY;
            if (libraryState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getLibraryState"));
            }
            return libraryState;
        }
        LibraryState libraryState = LibraryState.NEW_LIBRARY;
        if (libraryState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getLibraryState"));
        }
        return libraryState;
    }

    @NotNull
    protected FileState getJarState(@NotNull Project project, @NotNull File targetFile, @NotNull OrderRootType jarType, boolean useBundled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
        }
        if (jarType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarType", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
        }
        if (targetFile.exists()) {
            FileState fileState = FileState.EXISTS;
            if (fileState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
            }
            return fileState;
        }
        if (this.getPathFromLibrary(project, jarType) != null) {
            FileState fileState = FileState.COPY;
            if (fileState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
            }
            return fileState;
        }
        if (useBundled) {
            FileState fileState = FileState.DO_NOT_COPY;
            if (fileState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
            }
            return fileState;
        }
        FileState fileState = FileState.COPY;
        if (fileState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getJarState"));
        }
        return fileState;
    }

    @NotNull
    private String getPathToCopyFileTo(@NotNull Project project, @NotNull OrderRootType jarType, @NotNull String defaultDir, @Nullable String pathFromDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathToCopyFileTo"));
        }
        if (jarType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarType", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathToCopyFileTo"));
        }
        if (defaultDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDir", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathToCopyFileTo"));
        }
        if (pathFromDialog != null) {
            String string = pathFromDialog;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathToCopyFileTo"));
            }
            return string;
        }
        String pathFromLibrary = this.getPathFromLibrary(project, jarType);
        if (pathFromLibrary != null) {
            String string = pathFromLibrary;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathToCopyFileTo"));
            }
            return string;
        }
        String string = defaultDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "getPathToCopyFileTo"));
        }
        return string;
    }

    protected File assertFileExists(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "assertFileExists"));
        }
        if (!file2.exists()) {
            this.showError("Couldn't find file: " + file2.getPath());
        }
        return file2;
    }

    public void copySourcesToPathFromLibrary(@NotNull Library library, @NotNull NotificationMessageCollector collector2) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "copySourcesToPathFromLibrary"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "copySourcesToPathFromLibrary"));
        }
        String dirToJarFromLibrary = KotlinWithLibraryConfigurator.getPathFromLibrary(library, OrderRootType.SOURCES);
        assert (dirToJarFromLibrary != null) : "Directory to file from library should be non null";
        this.copyFileToDir(this.getExistingJarFiles().getRuntimeSourcesJar(), dirToJarFromLibrary, collector2);
    }

    public boolean changeOldSourcesPathIfNeeded(@NotNull Library library, @NotNull NotificationMessageCollector collector2) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "changeOldSourcesPathIfNeeded"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "changeOldSourcesPathIfNeeded"));
        }
        if (!this.removeOldSourcesRootIfNeeded(library, collector2)) {
            return false;
        }
        String parentDir = KotlinWithLibraryConfigurator.getPathFromLibrary(library, OrderRootType.CLASSES);
        assert (parentDir != null) : "Parent dir for classes jar should exists for Kotlin library";
        return KotlinWithLibraryConfigurator.addSourcesToLibraryIfNeeded(library, this.getExistingJarFiles().getRuntimeSourcesDestination(parentDir), collector2);
    }

    protected boolean removeOldSourcesRootIfNeeded(@NotNull Library library, @NotNull NotificationMessageCollector collector2) {
        String[] librarySourceRoots;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "removeOldSourcesRootIfNeeded"));
        }
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator", "removeOldSourcesRootIfNeeded"));
        }
        String oldLibrarySourceRoot = this.getOldSourceRootUrl(library);
        for (String sourceRoot : librarySourceRoots = library.getUrls(OrderRootType.SOURCES)) {
            if (!sourceRoot.equals(oldLibrarySourceRoot)) continue;
            final Library.ModifiableModel model = library.getModifiableModel();
            model.removeRoot(oldLibrarySourceRoot, OrderRootType.SOURCES);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    model.commit();
                }
            });
            collector2.addMessage("Source root '" + oldLibrarySourceRoot + "' was removed for " + library.getName() + " library");
            return true;
        }
        return false;
    }

    KotlinWithLibraryConfigurator() {
    }

    protected static enum LibraryState {
        LIBRARY,
        NON_CONFIGURED_LIBRARY,
        NEW_LIBRARY;

    }

    protected static enum FileState {
        EXISTS,
        COPY,
        DO_NOT_COPY;

    }
}

