/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinPropertyBreakpointProperties;

public class KotlinBreakpointFiltersPanel<T extends KotlinPropertyBreakpointProperties, B extends XBreakpoint<T>>
extends XBreakpointCustomPropertiesPanel<B> {
    private JPanel myConditionsPanel;
    private JPanel myInstanceFiltersPanel;
    private JCheckBox myInstanceFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JPanel myClassFiltersPanel;
    private JCheckBox myClassFiltersCheckBox;
    private JPanel myClassFiltersFieldPanel;
    private JPanel myPassCountPanel;
    private JCheckBox myPassCountCheckbox;
    private JTextField myPassCountField;
    private final FieldPanel myInstanceFiltersField;
    private final FieldPanel myClassFiltersField;
    private com.intellij.ui.classFilter.ClassFilter[] myClassFilters = com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY;
    private com.intellij.ui.classFilter.ClassFilter[] myClassExclusionFilters = com.intellij.ui.classFilter.ClassFilter.EMPTY_ARRAY;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    protected final Project myProject;
    private PsiClass myBreakpointPsiClass;

    public KotlinBreakpointFiltersPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myInstanceFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinBreakpointFiltersPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(KotlinBreakpointFiltersPanel.this.myProject);
                _dialog.setFilters(KotlinBreakpointFiltersPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    KotlinBreakpointFiltersPanel.access$102(KotlinBreakpointFiltersPanel.this, _dialog.getFilters());
                    KotlinBreakpointFiltersPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        this.myClassFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinBreakpointFiltersPanel.this.reloadClassFilters();
                ClassFilter classFilter = KotlinBreakpointFiltersPanel.this.createClassConditionFilter();
                EditClassFiltersDialog _dialog = new EditClassFiltersDialog(KotlinBreakpointFiltersPanel.this.myProject, classFilter);
                _dialog.setFilters(KotlinBreakpointFiltersPanel.this.myClassFilters, KotlinBreakpointFiltersPanel.this.myClassExclusionFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    KotlinBreakpointFiltersPanel.access$402(KotlinBreakpointFiltersPanel.this, _dialog.getFilters());
                    KotlinBreakpointFiltersPanel.access$502(KotlinBreakpointFiltersPanel.this, _dialog.getExclusionFilters());
                    KotlinBreakpointFiltersPanel.this.updateClassFilterEditor(true);
                }
            }
        }, null);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinBreakpointFiltersPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(updateListener);
        this.myInstanceFiltersCheckBox.addActionListener(updateListener);
        this.myClassFiltersCheckBox.addActionListener(updateListener);
        ToolTipManager.sharedInstance().registerComponent(this.myClassFiltersField.getTextField());
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        KotlinBreakpointFiltersPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        KotlinBreakpointFiltersPanel.insert(this.myClassFiltersFieldPanel, (JComponent)this.myClassFiltersField);
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myPassCountCheckbox, (JComponent)this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myInstanceFiltersCheckBox, (JComponent)this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myClassFiltersCheckBox, (JComponent)this.myClassFiltersField.getTextField());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myConditionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointFiltersPanel", "getComponent"));
        }
        return jPanel;
    }

    public boolean isVisibleOnPopup(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointFiltersPanel", "isVisibleOnPopup"));
        }
        JavaBreakpointProperties properties2 = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties2 != null) {
            return properties2.isCOUNT_FILTER_ENABLED() || properties2.isCLASS_FILTERS_ENABLED() || properties2.isINSTANCE_FILTERS_ENABLED();
        }
        return false;
    }

    public void saveTo(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointFiltersPanel", "saveTo"));
        }
        JavaBreakpointProperties properties2 = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties2 == null) {
            return;
        }
        boolean changed = false;
        try {
            int filter2;
            String text2 = this.myPassCountField.getText().trim();
            int n = filter2 = !text2.isEmpty() ? Integer.parseInt(text2) : 0;
            if (filter2 < 0) {
                filter2 = 0;
            }
            changed = properties2.setCOUNT_FILTER(filter2);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        changed = properties2.setCOUNT_FILTER_ENABLED(properties2.getCOUNT_FILTER() > 0 && this.myPassCountCheckbox.isSelected()) || changed;
        this.reloadInstanceFilters();
        this.reloadClassFilters();
        this.updateInstanceFilterEditor(true);
        this.updateClassFilterEditor(true);
        changed = properties2.setINSTANCE_FILTERS_ENABLED(this.myInstanceFiltersField.getText().length() > 0 && this.myInstanceFiltersCheckBox.isSelected()) || changed;
        changed = properties2.setCLASS_FILTERS_ENABLED(this.myClassFiltersField.getText().length() > 0 && this.myClassFiltersCheckBox.isSelected()) || changed;
        changed = properties2.setClassFilters(this.myClassFilters) || changed;
        changed = properties2.setClassExclusionFilters(this.myClassExclusionFilters) || changed;
        boolean bl = changed = properties2.setInstanceFilters(this.myInstanceFilters) || changed;
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static void insert(JPanel panel, JComponent component) {
        panel.setLayout(new BorderLayout());
        panel.add((Component)component, "Center");
    }

    public void loadFrom(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointFiltersPanel", "loadFrom"));
        }
        JavaBreakpointProperties properties2 = (JavaBreakpointProperties)breakpoint.getProperties();
        if (properties2 != null) {
            if (properties2.getCOUNT_FILTER() > 0) {
                this.myPassCountField.setText(Integer.toString(properties2.getCOUNT_FILTER()));
            } else {
                this.myPassCountField.setText("");
            }
            this.myPassCountCheckbox.setSelected(properties2.isCOUNT_FILTER_ENABLED());
            this.myInstanceFiltersCheckBox.setSelected(properties2.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFiltersField.setEnabled(properties2.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFiltersField.getTextField().setEditable(properties2.isINSTANCE_FILTERS_ENABLED());
            this.myInstanceFilters = properties2.getInstanceFilters();
            this.updateInstanceFilterEditor(true);
            this.myClassFiltersCheckBox.setSelected(properties2.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.setEnabled(properties2.isCLASS_FILTERS_ENABLED());
            this.myClassFiltersField.getTextField().setEditable(properties2.isCLASS_FILTERS_ENABLED());
            this.myClassFilters = properties2.getClassFilters();
            this.myClassExclusionFilters = properties2.getClassExclusionFilters();
            this.updateClassFilterEditor(true);
            XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        }
        this.updateCheckboxes();
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (!instanceFilter.isEnabled()) continue;
            filters.add(Long.toString(instanceFilter.getId()));
        }
        if (updateText) {
            this.myInstanceFiltersField.setText(StringUtil.join(filters, (String)" "));
        }
        String tipText = KotlinBreakpointFiltersPanel.concatWithEx(filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n");
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadClassFilters() {
        String filtersText = this.myClassFiltersField.getText();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> classFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> exclusionFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        int startFilter = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && !Character.isWhitespace(filtersText.charAt(i))) {
                if (startFilter != -1) continue;
                startFilter = i;
                continue;
            }
            if (startFilter < 0) continue;
            if (filtersText.charAt(startFilter) == '-') {
                exclusionFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter + 1, i)));
            } else {
                classFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter, i)));
            }
            startFilter = -1;
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (classFilter.isEnabled()) continue;
            classFilters.add(classFilter);
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (classFilter.isEnabled()) continue;
            exclusionFilters.add(classFilter);
        }
        this.myClassFilters = classFilters.toArray(new com.intellij.ui.classFilter.ClassFilter[classFilters.size()]);
        this.myClassExclusionFilters = exclusionFilters.toArray(new com.intellij.ui.classFilter.ClassFilter[exclusionFilters.size()]);
    }

    private void reloadInstanceFilters() {
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && Character.isDigit(filtersText.charAt(i))) {
                if (startNumber != -1) continue;
                startNumber = i;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create((String)filtersText.substring(startNumber, i)));
            startNumber = -1;
        }
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (instanceFilter.isEnabled()) continue;
            idxs.add(instanceFilter);
        }
        this.myInstanceFilters = idxs.toArray(new InstanceFilter[idxs.size()]);
    }

    private void updateClassFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (!classFilter.isEnabled()) continue;
            filters.add(classFilter.getPattern());
        }
        ArrayList<String> excludeFilters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (!classFilter.isEnabled()) continue;
            excludeFilters.add("-" + classFilter.getPattern());
        }
        if (updateText) {
            String editorText = StringUtil.join(filters, (String)" ");
            if (!filters.isEmpty()) {
                editorText = editorText + " ";
            }
            editorText = editorText + StringUtil.join(excludeFilters, (String)" ");
            this.myClassFiltersField.setText(editorText);
        }
        int width = (int)Math.sqrt(this.myClassExclusionFilters.length + this.myClassFilters.length) + 1;
        String tipText = KotlinBreakpointFiltersPanel.concatWithEx(filters, " ", width, "\n");
        if (!filters.isEmpty()) {
            tipText = tipText + "\n";
        }
        tipText = tipText + KotlinBreakpointFiltersPanel.concatWithEx(excludeFilters, " ", width, "\n");
        this.myClassFiltersField.getTextField().setToolTipText(tipText);
    }

    private static String concatWithEx(List<String> s, String concator, int N, String NthConcator) {
        String result2 = "";
        int i = 1;
        Iterator<String> iterator2 = s.iterator();
        while (iterator2.hasNext()) {
            String str = iterator2.next();
            result2 = result2 + str;
            if (iterator2.hasNext()) {
                result2 = i % N == 0 ? result2 + NthConcator : result2 + concator;
            }
            ++i;
        }
        return result2;
    }

    protected ClassFilter createClassConditionFilter() {
        ClassFilter classFilter = this.myBreakpointPsiClass != null ? new ClassFilter(){

            public boolean isAccepted(PsiClass aClass2) {
                return KotlinBreakpointFiltersPanel.this.myBreakpointPsiClass == aClass2 || aClass2.isInheritor(KotlinBreakpointFiltersPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected void updateCheckboxes() {
        boolean passCountApplicable = true;
        if (this.myInstanceFiltersCheckBox.isSelected() || this.myClassFiltersCheckBox.isSelected()) {
            passCountApplicable = false;
        }
        this.myPassCountCheckbox.setEnabled(passCountApplicable);
        boolean passCountSelected = this.myPassCountCheckbox.isSelected();
        this.myInstanceFiltersCheckBox.setEnabled(!passCountSelected);
        this.myClassFiltersCheckBox.setEnabled(!passCountSelected);
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.getTextField().setEditable(this.myClassFiltersCheckBox.isSelected());
    }

    static /* synthetic */ InstanceFilter[] access$102(KotlinBreakpointFiltersPanel x0, InstanceFilter[] x1) {
        x0.myInstanceFilters = x1;
        return x1;
    }

    static /* synthetic */ com.intellij.ui.classFilter.ClassFilter[] access$402(KotlinBreakpointFiltersPanel x0, com.intellij.ui.classFilter.ClassFilter[] x1) {
        x0.myClassFilters = x1;
        return x1;
    }

    static /* synthetic */ com.intellij.ui.classFilter.ClassFilter[] access$502(KotlinBreakpointFiltersPanel x0, com.intellij.ui.classFilter.ClassFilter[] x1) {
        x0.myClassExclusionFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JPanel jPanel4;
        JCheckBox jCheckBox3;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConditionsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(4, 2, new Insets(2, 2, 5, 5), -1, 7, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.conditions"), (int)0, (int)0, null, null));
        this.myInstanceFiltersPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.instance.filters"));
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myInstanceFiltersFieldPanel = jPanel4 = new JPanel();
        jPanel8.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.class.filters"));
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClassFiltersFieldPanel = jPanel2 = new JPanel();
        jPanel9.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myPassCountPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.pass.count"));
        jCheckBox.setMargin(new Insets(2, 2, 0, 2));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(10);
        ((Component)jTextField).setEnabled(false);
        jPanel10.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTextField
    extends JTextField {
        @Override
        public String getToolTipText(MouseEvent event) {
            KotlinBreakpointFiltersPanel.this.reloadClassFilters();
            KotlinBreakpointFiltersPanel.this.updateClassFilterEditor(false);
            KotlinBreakpointFiltersPanel.this.reloadInstanceFilters();
            KotlinBreakpointFiltersPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent(this);
            return toolTip;
        }
    }
}

